/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsResponse;
import software.amazon.awssdk.services.iam.model.Tag;

public class ListInstanceProfileTagsPublisher
implements SdkPublisher<ListInstanceProfileTagsResponse> {
    private final IamAsyncClient client;
    private final ListInstanceProfileTagsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInstanceProfileTagsPublisher(IamAsyncClient client, ListInstanceProfileTagsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInstanceProfileTagsPublisher(IamAsyncClient client, ListInstanceProfileTagsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInstanceProfileTagsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInstanceProfileTagsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Tag> tags() {
        return this.flatMapIterable(response -> response.tags());
    }

    private class ListInstanceProfileTagsResponseFetcher
    implements AsyncPageFetcher<ListInstanceProfileTagsResponse> {
        private ListInstanceProfileTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceProfileTagsResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<ListInstanceProfileTagsResponse> nextPage(ListInstanceProfileTagsResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceProfileTagsPublisher.this.client.listInstanceProfileTags(ListInstanceProfileTagsPublisher.this.firstRequest);
            }
            return ListInstanceProfileTagsPublisher.this.client.listInstanceProfileTags((ListInstanceProfileTagsRequest)((Object)ListInstanceProfileTagsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

