/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesResponse;

public class ListAttachedUserPoliciesPublisher
implements SdkPublisher<ListAttachedUserPoliciesResponse> {
    private final IamAsyncClient client;
    private final ListAttachedUserPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAttachedUserPoliciesPublisher(IamAsyncClient client, ListAttachedUserPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAttachedUserPoliciesPublisher(IamAsyncClient client, ListAttachedUserPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAttachedUserPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAttachedUserPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AttachedPolicy> attachedPolicies() {
        return this.flatMapIterable(response -> response.attachedPolicies());
    }

    private class ListAttachedUserPoliciesResponseFetcher
    implements AsyncPageFetcher<ListAttachedUserPoliciesResponse> {
        private ListAttachedUserPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedUserPoliciesResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<ListAttachedUserPoliciesResponse> nextPage(ListAttachedUserPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedUserPoliciesPublisher.this.client.listAttachedUserPolicies(ListAttachedUserPoliciesPublisher.this.firstRequest);
            }
            return ListAttachedUserPoliciesPublisher.this.client.listAttachedUserPolicies((ListAttachedUserPoliciesRequest)((Object)ListAttachedUserPoliciesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

