/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesResponse;

public class ListAttachedGroupPoliciesPublisher
implements SdkPublisher<ListAttachedGroupPoliciesResponse> {
    private final IamAsyncClient client;
    private final ListAttachedGroupPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAttachedGroupPoliciesPublisher(IamAsyncClient client, ListAttachedGroupPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAttachedGroupPoliciesPublisher(IamAsyncClient client, ListAttachedGroupPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAttachedGroupPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAttachedGroupPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AttachedPolicy> attachedPolicies() {
        return this.flatMapIterable(response -> response.attachedPolicies());
    }

    private class ListAttachedGroupPoliciesResponseFetcher
    implements AsyncPageFetcher<ListAttachedGroupPoliciesResponse> {
        private ListAttachedGroupPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedGroupPoliciesResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<ListAttachedGroupPoliciesResponse> nextPage(ListAttachedGroupPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedGroupPoliciesPublisher.this.client.listAttachedGroupPolicies(ListAttachedGroupPoliciesPublisher.this.firstRequest);
            }
            return ListAttachedGroupPoliciesPublisher.this.client.listAttachedGroupPolicies((ListAttachedGroupPoliciesRequest)((Object)ListAttachedGroupPoliciesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

