/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest;
import software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse;

public class ListAccountAliasesPublisher
implements SdkPublisher<ListAccountAliasesResponse> {
    private final IamAsyncClient client;
    private final ListAccountAliasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccountAliasesPublisher(IamAsyncClient client, ListAccountAliasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccountAliasesPublisher(IamAsyncClient client, ListAccountAliasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccountAliasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccountAliasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> accountAliases() {
        return this.flatMapIterable(response -> response.accountAliases());
    }

    private class ListAccountAliasesResponseFetcher
    implements AsyncPageFetcher<ListAccountAliasesResponse> {
        private ListAccountAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountAliasesResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<ListAccountAliasesResponse> nextPage(ListAccountAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListAccountAliasesPublisher.this.client.listAccountAliases(ListAccountAliasesPublisher.this.firstRequest);
            }
            return ListAccountAliasesPublisher.this.client.listAccountAliases((ListAccountAliasesRequest)((Object)ListAccountAliasesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

