/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest;
import software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse;
import software.amazon.awssdk.services.iam.model.GroupDetail;
import software.amazon.awssdk.services.iam.model.ManagedPolicyDetail;
import software.amazon.awssdk.services.iam.model.RoleDetail;
import software.amazon.awssdk.services.iam.model.UserDetail;

public class GetAccountAuthorizationDetailsPublisher
implements SdkPublisher<GetAccountAuthorizationDetailsResponse> {
    private final IamAsyncClient client;
    private final GetAccountAuthorizationDetailsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetAccountAuthorizationDetailsPublisher(IamAsyncClient client, GetAccountAuthorizationDetailsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetAccountAuthorizationDetailsPublisher(IamAsyncClient client, GetAccountAuthorizationDetailsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetAccountAuthorizationDetailsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetAccountAuthorizationDetailsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UserDetail> userDetailList() {
        return this.flatMapIterable(response -> response.userDetailList());
    }

    public final SdkPublisher<GroupDetail> groupDetailList() {
        return this.flatMapIterable(response -> response.groupDetailList());
    }

    public final SdkPublisher<RoleDetail> roleDetailList() {
        return this.flatMapIterable(response -> response.roleDetailList());
    }

    public final SdkPublisher<ManagedPolicyDetail> policies() {
        return this.flatMapIterable(response -> response.policies());
    }

    private class GetAccountAuthorizationDetailsResponseFetcher
    implements AsyncPageFetcher<GetAccountAuthorizationDetailsResponse> {
        private GetAccountAuthorizationDetailsResponseFetcher() {
        }

        public boolean hasNextPage(GetAccountAuthorizationDetailsResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<GetAccountAuthorizationDetailsResponse> nextPage(GetAccountAuthorizationDetailsResponse previousPage) {
            if (previousPage == null) {
                return GetAccountAuthorizationDetailsPublisher.this.client.getAccountAuthorizationDetails(GetAccountAuthorizationDetailsPublisher.this.firstRequest);
            }
            return GetAccountAuthorizationDetailsPublisher.this.client.getAccountAuthorizationDetails((GetAccountAuthorizationDetailsRequest)((Object)GetAccountAuthorizationDetailsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

