/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.AttachedPermissionsBoundary;
import software.amazon.awssdk.services.iam.model.Tag;
import software.amazon.awssdk.services.iam.model._tagListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class User
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, User> {
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(User.getter(User::path)).setter(User.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(User.getter(User::userName)).setter(User.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(User.getter(User::userId)).setter(User.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(User.getter(User::arn)).setter(User.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(User.getter(User::createDate)).setter(User.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<Instant> PASSWORD_LAST_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PasswordLastUsed").getter(User.getter(User::passwordLastUsed)).setter(User.setter(Builder::passwordLastUsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordLastUsed").build()}).build();
    private static final SdkField<AttachedPermissionsBoundary> PERMISSIONS_BOUNDARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PermissionsBoundary").getter(User.getter(User::permissionsBoundary)).setter(User.setter(Builder::permissionsBoundary)).constructor(AttachedPermissionsBoundary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundary").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(User.getter(User::tags)).setter(User.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, USER_NAME_FIELD, USER_ID_FIELD, ARN_FIELD, CREATE_DATE_FIELD, PASSWORD_LAST_USED_FIELD, PERMISSIONS_BOUNDARY_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = User.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String path;
    private final String userName;
    private final String userId;
    private final String arn;
    private final Instant createDate;
    private final Instant passwordLastUsed;
    private final AttachedPermissionsBoundary permissionsBoundary;
    private final List<Tag> tags;

    private User(BuilderImpl builder) {
        this.path = builder.path;
        this.userName = builder.userName;
        this.userId = builder.userId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.passwordLastUsed = builder.passwordLastUsed;
        this.permissionsBoundary = builder.permissionsBoundary;
        this.tags = builder.tags;
    }

    public final String path() {
        return this.path;
    }

    public final String userName() {
        return this.userName;
    }

    public final String userId() {
        return this.userId;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final Instant passwordLastUsed() {
        return this.passwordLastUsed;
    }

    public final AttachedPermissionsBoundary permissionsBoundary() {
        return this.permissionsBoundary;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordLastUsed());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.passwordLastUsed(), other.passwordLastUsed()) && Objects.equals(this.permissionsBoundary(), other.permissionsBoundary()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"User").add("Path", (Object)this.path()).add("UserName", (Object)this.userName()).add("UserId", (Object)this.userId()).add("Arn", (Object)this.arn()).add("CreateDate", (Object)this.createDate()).add("PasswordLastUsed", (Object)this.passwordLastUsed()).add("PermissionsBoundary", (Object)this.permissionsBoundary()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "PasswordLastUsed": {
                return Optional.ofNullable(clazz.cast(this.passwordLastUsed()));
            }
            case "PermissionsBoundary": {
                return Optional.ofNullable(clazz.cast(this.permissionsBoundary()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Path", PATH_FIELD);
        map.put("UserName", USER_NAME_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("PasswordLastUsed", PASSWORD_LAST_USED_FIELD);
        map.put("PermissionsBoundary", PERMISSIONS_BOUNDARY_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private String userName;
        private String userId;
        private String arn;
        private Instant createDate;
        private Instant passwordLastUsed;
        private AttachedPermissionsBoundary permissionsBoundary;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            this.path(model.path);
            this.userName(model.userName);
            this.userId(model.userId);
            this.arn(model.arn);
            this.createDate(model.createDate);
            this.passwordLastUsed(model.passwordLastUsed);
            this.permissionsBoundary(model.permissionsBoundary);
            this.tags(model.tags);
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final Instant getPasswordLastUsed() {
            return this.passwordLastUsed;
        }

        public final void setPasswordLastUsed(Instant passwordLastUsed) {
            this.passwordLastUsed = passwordLastUsed;
        }

        @Override
        public final Builder passwordLastUsed(Instant passwordLastUsed) {
            this.passwordLastUsed = passwordLastUsed;
            return this;
        }

        public final AttachedPermissionsBoundary.Builder getPermissionsBoundary() {
            return this.permissionsBoundary != null ? this.permissionsBoundary.toBuilder() : null;
        }

        public final void setPermissionsBoundary(AttachedPermissionsBoundary.BuilderImpl permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary != null ? permissionsBoundary.build() : null;
        }

        @Override
        public final Builder permissionsBoundary(AttachedPermissionsBoundary permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = _tagListTypeCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListTypeCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public User build() {
            return new User(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, User> {
        public Builder path(String var1);

        public Builder userName(String var1);

        public Builder userId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Instant var1);

        public Builder passwordLastUsed(Instant var1);

        public Builder permissionsBoundary(AttachedPermissionsBoundary var1);

        default public Builder permissionsBoundary(Consumer<AttachedPermissionsBoundary.Builder> permissionsBoundary) {
            return this.permissionsBoundary((AttachedPermissionsBoundary)((AttachedPermissionsBoundary.Builder)AttachedPermissionsBoundary.builder().applyMutation(permissionsBoundary)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

