/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.model.AccessKeyMetadata;
import software.amazon.awssdk.services.iam.model.ListAccessKeysRequest;
import software.amazon.awssdk.services.iam.model.ListAccessKeysResponse;

public class ListAccessKeysPublisher
implements SdkPublisher<ListAccessKeysResponse> {
    private final IamAsyncClient client;
    private final ListAccessKeysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessKeysPublisher(IamAsyncClient client, ListAccessKeysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessKeysPublisher(IamAsyncClient client, ListAccessKeysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessKeysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessKeysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccessKeyMetadata> accessKeyMetadata() {
        Function<ListAccessKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.accessKeyMetadata() != null) {
                return response.accessKeyMetadata().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccessKeysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListAccessKeysPublisher resume(ListAccessKeysResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAccessKeysPublisher(this.client, (ListAccessKeysRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListAccessKeysPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListAccessKeysResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListAccessKeysResponseFetcher
    implements AsyncPageFetcher<ListAccessKeysResponse> {
        private ListAccessKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessKeysResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListAccessKeysResponse> nextPage(ListAccessKeysResponse previousPage) {
            if (previousPage == null) {
                return ListAccessKeysPublisher.this.client.listAccessKeys(ListAccessKeysPublisher.this.firstRequest);
            }
            return ListAccessKeysPublisher.this.client.listAccessKeys((ListAccessKeysRequest)((Object)ListAccessKeysPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

