/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class _summaryMapTypeCopier {
    static Map<String, Integer> copy(Map<String, Integer> summaryMapTypeParam) {
        Map<String, Integer> map;
        if (summaryMapTypeParam == null || summaryMapTypeParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Integer> modifiableMap = new LinkedHashMap<>(summaryMapTypeParam.size());
            summaryMapTypeParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Integer> copyEnumToString(Map<SummaryKeyType, Integer> summaryMapTypeParam) {
        Map<String, Integer> map;
        if (summaryMapTypeParam == null || summaryMapTypeParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Integer> modifiableMap = new LinkedHashMap<>(summaryMapTypeParam.size());
            summaryMapTypeParam.forEach((key, value) -> {
                String result = key == null ? null : key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<SummaryKeyType, Integer> copyStringToEnum(Map<String, Integer> summaryMapTypeParam) {
        Map<SummaryKeyType, Integer> map;
        if (summaryMapTypeParam == null || summaryMapTypeParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<SummaryKeyType, Integer> modifiableMap = new LinkedHashMap<>(summaryMapTypeParam.size());
            summaryMapTypeParam.forEach((key, value) -> {
                SummaryKeyType result = SummaryKeyType.fromValue(key);
                if (result != SummaryKeyType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
