/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a
 * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetCredentialReport.html">GetCredentialReport</a>
 * request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCredentialReportResponse extends IamResponse implements
        ToCopyableBuilder<GetCredentialReportResponse.Builder, GetCredentialReportResponse> {
    private static final SdkField<SdkBytes> CONTENT_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Content").getter(getter(GetCredentialReportResponse::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> REPORT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportFormat").getter(getter(GetCredentialReportResponse::reportFormatAsString))
            .setter(setter(Builder::reportFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportFormat").build()).build();

    private static final SdkField<Instant> GENERATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("GeneratedTime").getter(getter(GetCredentialReportResponse::generatedTime))
            .setter(setter(Builder::generatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            REPORT_FORMAT_FIELD, GENERATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SdkBytes content;

    private final String reportFormat;

    private final Instant generatedTime;

    private GetCredentialReportResponse(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
        this.reportFormat = builder.reportFormat;
        this.generatedTime = builder.generatedTime;
    }

    /**
     * <p>
     * Contains the credential report. The report is Base64-encoded.
     * </p>
     * 
     * @return Contains the credential report. The report is Base64-encoded.
     */
    public final SdkBytes content() {
        return content;
    }

    /**
     * <p>
     * The format (MIME type) of the credential report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportFormat} will
     * return {@link ReportFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reportFormatAsString}.
     * </p>
     * 
     * @return The format (MIME type) of the credential report.
     * @see ReportFormatType
     */
    public final ReportFormatType reportFormat() {
        return ReportFormatType.fromValue(reportFormat);
    }

    /**
     * <p>
     * The format (MIME type) of the credential report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportFormat} will
     * return {@link ReportFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reportFormatAsString}.
     * </p>
     * 
     * @return The format (MIME type) of the credential report.
     * @see ReportFormatType
     */
    public final String reportFormatAsString() {
        return reportFormat;
    }

    /**
     * <p>
     * The date and time when the credential report was created, in <a href="http://www.iso.org/iso/iso8601">ISO 8601
     * date-time format</a>.
     * </p>
     * 
     * @return The date and time when the credential report was created, in <a href="http://www.iso.org/iso/iso8601">ISO
     *         8601 date-time format</a>.
     */
    public final Instant generatedTime() {
        return generatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(reportFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(generatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCredentialReportResponse)) {
            return false;
        }
        GetCredentialReportResponse other = (GetCredentialReportResponse) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(reportFormatAsString(), other.reportFormatAsString())
                && Objects.equals(generatedTime(), other.generatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCredentialReportResponse").add("Content", content())
                .add("ReportFormat", reportFormatAsString()).add("GeneratedTime", generatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "ReportFormat":
            return Optional.ofNullable(clazz.cast(reportFormatAsString()));
        case "GeneratedTime":
            return Optional.ofNullable(clazz.cast(generatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Content", CONTENT_FIELD);
        map.put("ReportFormat", REPORT_FORMAT_FIELD);
        map.put("GeneratedTime", GENERATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCredentialReportResponse, T> g) {
        return obj -> g.apply((GetCredentialReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCredentialReportResponse> {
        /**
         * <p>
         * Contains the credential report. The report is Base64-encoded.
         * </p>
         * 
         * @param content
         *        Contains the credential report. The report is Base64-encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(SdkBytes content);

        /**
         * <p>
         * The format (MIME type) of the credential report.
         * </p>
         * 
         * @param reportFormat
         *        The format (MIME type) of the credential report.
         * @see ReportFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportFormatType
         */
        Builder reportFormat(String reportFormat);

        /**
         * <p>
         * The format (MIME type) of the credential report.
         * </p>
         * 
         * @param reportFormat
         *        The format (MIME type) of the credential report.
         * @see ReportFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportFormatType
         */
        Builder reportFormat(ReportFormatType reportFormat);

        /**
         * <p>
         * The date and time when the credential report was created, in <a href="http://www.iso.org/iso/iso8601">ISO
         * 8601 date-time format</a>.
         * </p>
         * 
         * @param generatedTime
         *        The date and time when the credential report was created, in <a
         *        href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedTime(Instant generatedTime);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private SdkBytes content;

        private String reportFormat;

        private Instant generatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCredentialReportResponse model) {
            super(model);
            content(model.content);
            reportFormat(model.reportFormat);
            generatedTime(model.generatedTime);
        }

        public final ByteBuffer getContent() {
            return content == null ? null : content.asByteBuffer();
        }

        public final void setContent(ByteBuffer content) {
            content(content == null ? null : SdkBytes.fromByteBuffer(content));
        }

        @Override
        public final Builder content(SdkBytes content) {
            this.content = content;
            return this;
        }

        public final String getReportFormat() {
            return reportFormat;
        }

        public final void setReportFormat(String reportFormat) {
            this.reportFormat = reportFormat;
        }

        @Override
        public final Builder reportFormat(String reportFormat) {
            this.reportFormat = reportFormat;
            return this;
        }

        @Override
        public final Builder reportFormat(ReportFormatType reportFormat) {
            this.reportFormat(reportFormat == null ? null : reportFormat.toString());
            return this;
        }

        public final Instant getGeneratedTime() {
            return generatedTime;
        }

        public final void setGeneratedTime(Instant generatedTime) {
            this.generatedTime = generatedTime;
        }

        @Override
        public final Builder generatedTime(Instant generatedTime) {
            this.generatedTime = generatedTime;
            return this;
        }

        @Override
        public GetCredentialReportResponse build() {
            return new GetCredentialReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
