/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an IAM group, including all of the group's policies.
 * </p>
 * <p>
 * This data type is used as a response element in the <a
 * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetAccountAuthorizationDetails.html"
 * >GetAccountAuthorizationDetails</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupDetail implements SdkPojo, Serializable, ToCopyableBuilder<GroupDetail.Builder, GroupDetail> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(GroupDetail::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(GroupDetail::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupId").getter(getter(GroupDetail::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GroupDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(GroupDetail::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<List<PolicyDetail>> GROUP_POLICY_LIST_FIELD = SdkField
            .<List<PolicyDetail>> builder(MarshallingType.LIST)
            .memberName("GroupPolicyList")
            .getter(getter(GroupDetail::groupPolicyList))
            .setter(setter(Builder::groupPolicyList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupPolicyList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AttachedPolicy>> ATTACHED_MANAGED_POLICIES_FIELD = SdkField
            .<List<AttachedPolicy>> builder(MarshallingType.LIST)
            .memberName("AttachedManagedPolicies")
            .getter(getter(GroupDetail::attachedManagedPolicies))
            .setter(setter(Builder::attachedManagedPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedManagedPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachedPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachedPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, GROUP_NAME_FIELD,
            GROUP_ID_FIELD, ARN_FIELD, CREATE_DATE_FIELD, GROUP_POLICY_LIST_FIELD, ATTACHED_MANAGED_POLICIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String path;

    private final String groupName;

    private final String groupId;

    private final String arn;

    private final Instant createDate;

    private final List<PolicyDetail> groupPolicyList;

    private final List<AttachedPolicy> attachedManagedPolicies;

    private GroupDetail(BuilderImpl builder) {
        this.path = builder.path;
        this.groupName = builder.groupName;
        this.groupId = builder.groupId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.groupPolicyList = builder.groupPolicyList;
        this.attachedManagedPolicies = builder.attachedManagedPolicies;
    }

    /**
     * <p>
     * The path to the group. For more information about paths, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     * 
     * @return The path to the group. For more information about paths, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
     *         <i>IAM User Guide</i>.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The friendly name that identifies the group.
     * </p>
     * 
     * @return The friendly name that identifies the group.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The stable and unique string identifying the group. For more information about IDs, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     * 
     * @return The stable and unique string identifying the group. For more information about IDs, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
     *         <i>IAM User Guide</i>.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * Returns the value of the Arn property for this object.
     * 
     * @return The value of the Arn property for this object.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the group was
     * created.
     * </p>
     * 
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
     *         group was created.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupPolicyList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupPolicyList() {
        return groupPolicyList != null && !(groupPolicyList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the inline policies embedded in the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupPolicyList} method.
     * </p>
     * 
     * @return A list of the inline policies embedded in the group.
     */
    public final List<PolicyDetail> groupPolicyList() {
        return groupPolicyList;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttachedManagedPolicies property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAttachedManagedPolicies() {
        return attachedManagedPolicies != null && !(attachedManagedPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the managed policies attached to the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachedManagedPolicies} method.
     * </p>
     * 
     * @return A list of the managed policies attached to the group.
     */
    public final List<AttachedPolicy> attachedManagedPolicies() {
        return attachedManagedPolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupPolicyList() ? groupPolicyList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachedManagedPolicies() ? attachedManagedPolicies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupDetail)) {
            return false;
        }
        GroupDetail other = (GroupDetail) obj;
        return Objects.equals(path(), other.path()) && Objects.equals(groupName(), other.groupName())
                && Objects.equals(groupId(), other.groupId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createDate(), other.createDate()) && hasGroupPolicyList() == other.hasGroupPolicyList()
                && Objects.equals(groupPolicyList(), other.groupPolicyList())
                && hasAttachedManagedPolicies() == other.hasAttachedManagedPolicies()
                && Objects.equals(attachedManagedPolicies(), other.attachedManagedPolicies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupDetail").add("Path", path()).add("GroupName", groupName()).add("GroupId", groupId())
                .add("Arn", arn()).add("CreateDate", createDate())
                .add("GroupPolicyList", hasGroupPolicyList() ? groupPolicyList() : null)
                .add("AttachedManagedPolicies", hasAttachedManagedPolicies() ? attachedManagedPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "GroupPolicyList":
            return Optional.ofNullable(clazz.cast(groupPolicyList()));
        case "AttachedManagedPolicies":
            return Optional.ofNullable(clazz.cast(attachedManagedPolicies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Path", PATH_FIELD);
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("GroupPolicyList", GROUP_POLICY_LIST_FIELD);
        map.put("AttachedManagedPolicies", ATTACHED_MANAGED_POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupDetail, T> g) {
        return obj -> g.apply((GroupDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupDetail> {
        /**
         * <p>
         * The path to the group. For more information about paths, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
         * <i>IAM User Guide</i>.
         * </p>
         * 
         * @param path
         *        The path to the group. For more information about paths, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in
         *        the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The friendly name that identifies the group.
         * </p>
         * 
         * @param groupName
         *        The friendly name that identifies the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The stable and unique string identifying the group. For more information about IDs, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
         * <i>IAM User Guide</i>.
         * </p>
         * 
         * @param groupId
         *        The stable and unique string identifying the group. For more information about IDs, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in
         *        the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * Sets the value of the Arn property for this object.
         *
         * @param arn
         *        The new value for the Arn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the group
         * was created.
         * </p>
         * 
         * @param createDate
         *        The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         *        group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * A list of the inline policies embedded in the group.
         * </p>
         * 
         * @param groupPolicyList
         *        A list of the inline policies embedded in the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupPolicyList(Collection<PolicyDetail> groupPolicyList);

        /**
         * <p>
         * A list of the inline policies embedded in the group.
         * </p>
         * 
         * @param groupPolicyList
         *        A list of the inline policies embedded in the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupPolicyList(PolicyDetail... groupPolicyList);

        /**
         * <p>
         * A list of the inline policies embedded in the group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iam.model.PolicyDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iam.model.PolicyDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iam.model.PolicyDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #groupPolicyList(List<PolicyDetail>)}.
         * 
         * @param groupPolicyList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iam.model.PolicyDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupPolicyList(java.util.Collection<PolicyDetail>)
         */
        Builder groupPolicyList(Consumer<PolicyDetail.Builder>... groupPolicyList);

        /**
         * <p>
         * A list of the managed policies attached to the group.
         * </p>
         * 
         * @param attachedManagedPolicies
         *        A list of the managed policies attached to the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies);

        /**
         * <p>
         * A list of the managed policies attached to the group.
         * </p>
         * 
         * @param attachedManagedPolicies
         *        A list of the managed policies attached to the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedManagedPolicies(AttachedPolicy... attachedManagedPolicies);

        /**
         * <p>
         * A list of the managed policies attached to the group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iam.model.AttachedPolicy.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iam.model.AttachedPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iam.model.AttachedPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #attachedManagedPolicies(List<AttachedPolicy>)}.
         * 
         * @param attachedManagedPolicies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iam.model.AttachedPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachedManagedPolicies(java.util.Collection<AttachedPolicy>)
         */
        Builder attachedManagedPolicies(Consumer<AttachedPolicy.Builder>... attachedManagedPolicies);
    }

    static final class BuilderImpl implements Builder {
        private String path;

        private String groupName;

        private String groupId;

        private String arn;

        private Instant createDate;

        private List<PolicyDetail> groupPolicyList = DefaultSdkAutoConstructList.getInstance();

        private List<AttachedPolicy> attachedManagedPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GroupDetail model) {
            path(model.path);
            groupName(model.groupName);
            groupId(model.groupId);
            arn(model.arn);
            createDate(model.createDate);
            groupPolicyList(model.groupPolicyList);
            attachedManagedPolicies(model.attachedManagedPolicies);
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final List<PolicyDetail.Builder> getGroupPolicyList() {
            List<PolicyDetail.Builder> result = _policyDetailListTypeCopier.copyToBuilder(this.groupPolicyList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupPolicyList(Collection<PolicyDetail.BuilderImpl> groupPolicyList) {
            this.groupPolicyList = _policyDetailListTypeCopier.copyFromBuilder(groupPolicyList);
        }

        @Override
        public final Builder groupPolicyList(Collection<PolicyDetail> groupPolicyList) {
            this.groupPolicyList = _policyDetailListTypeCopier.copy(groupPolicyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupPolicyList(PolicyDetail... groupPolicyList) {
            groupPolicyList(Arrays.asList(groupPolicyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupPolicyList(Consumer<PolicyDetail.Builder>... groupPolicyList) {
            groupPolicyList(Stream.of(groupPolicyList).map(c -> PolicyDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AttachedPolicy.Builder> getAttachedManagedPolicies() {
            List<AttachedPolicy.Builder> result = _attachedPoliciesListTypeCopier.copyToBuilder(this.attachedManagedPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachedManagedPolicies(Collection<AttachedPolicy.BuilderImpl> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copyFromBuilder(attachedManagedPolicies);
        }

        @Override
        public final Builder attachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copy(attachedManagedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(AttachedPolicy... attachedManagedPolicies) {
            attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(Consumer<AttachedPolicy.Builder>... attachedManagedPolicies) {
            attachedManagedPolicies(Stream.of(attachedManagedPolicies)
                    .map(c -> AttachedPolicy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GroupDetail build() {
            return new GroupDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
