/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOrganizationsAccessReportResponse extends IamResponse implements
        ToCopyableBuilder<GetOrganizationsAccessReportResponse.Builder, GetOrganizationsAccessReportResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(GetOrganizationsAccessReportResponse::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<Instant> JOB_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("JobCreationDate").getter(getter(GetOrganizationsAccessReportResponse::jobCreationDate))
            .setter(setter(Builder::jobCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobCreationDate").build()).build();

    private static final SdkField<Instant> JOB_COMPLETION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("JobCompletionDate").getter(getter(GetOrganizationsAccessReportResponse::jobCompletionDate))
            .setter(setter(Builder::jobCompletionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobCompletionDate").build()).build();

    private static final SdkField<Integer> NUMBER_OF_SERVICES_ACCESSIBLE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfServicesAccessible")
            .getter(getter(GetOrganizationsAccessReportResponse::numberOfServicesAccessible))
            .setter(setter(Builder::numberOfServicesAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfServicesAccessible").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_SERVICES_NOT_ACCESSED_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfServicesNotAccessed")
            .getter(getter(GetOrganizationsAccessReportResponse::numberOfServicesNotAccessed))
            .setter(setter(Builder::numberOfServicesNotAccessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfServicesNotAccessed")
                    .build()).build();

    private static final SdkField<List<AccessDetail>> ACCESS_DETAILS_FIELD = SdkField
            .<List<AccessDetail>> builder(MarshallingType.LIST)
            .memberName("AccessDetails")
            .getter(getter(GetOrganizationsAccessReportResponse::accessDetails))
            .setter(setter(Builder::accessDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated").getter(getter(GetOrganizationsAccessReportResponse::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(GetOrganizationsAccessReportResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<ErrorDetails> ERROR_DETAILS_FIELD = SdkField.<ErrorDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ErrorDetails").getter(getter(GetOrganizationsAccessReportResponse::errorDetails))
            .setter(setter(Builder::errorDetails)).constructor(ErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD,
            JOB_CREATION_DATE_FIELD, JOB_COMPLETION_DATE_FIELD, NUMBER_OF_SERVICES_ACCESSIBLE_FIELD,
            NUMBER_OF_SERVICES_NOT_ACCESSED_FIELD, ACCESS_DETAILS_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD, ERROR_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobStatus;

    private final Instant jobCreationDate;

    private final Instant jobCompletionDate;

    private final Integer numberOfServicesAccessible;

    private final Integer numberOfServicesNotAccessed;

    private final List<AccessDetail> accessDetails;

    private final Boolean isTruncated;

    private final String marker;

    private final ErrorDetails errorDetails;

    private GetOrganizationsAccessReportResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.jobCreationDate = builder.jobCreationDate;
        this.jobCompletionDate = builder.jobCompletionDate;
        this.numberOfServicesAccessible = builder.numberOfServicesAccessible;
        this.numberOfServicesNotAccessed = builder.numberOfServicesNotAccessed;
        this.accessDetails = builder.accessDetails;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
        this.errorDetails = builder.errorDetails;
    }

    /**
     * <p>
     * The status of the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the job.
     * @see JobStatusType
     */
    public final JobStatusType jobStatus() {
        return JobStatusType.fromValue(jobStatus);
    }

    /**
     * <p>
     * The status of the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the job.
     * @see JobStatusType
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report job
     * was created.
     * </p>
     * 
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
     *         report job was created.
     */
    public final Instant jobCreationDate() {
        return jobCreationDate;
    }

    /**
     * <p>
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the generated
     * report job was completed or failed.
     * </p>
     * <p>
     * This field is null if the job is still in progress, as indicated by a job status value of
     * <code>IN_PROGRESS</code>.
     * </p>
     * 
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
     *         generated report job was completed or failed.</p>
     *         <p>
     *         This field is null if the job is still in progress, as indicated by a job status value of
     *         <code>IN_PROGRESS</code>.
     */
    public final Instant jobCompletionDate() {
        return jobCompletionDate;
    }

    /**
     * <p>
     * The number of services that the applicable SCPs allow account principals to access.
     * </p>
     * 
     * @return The number of services that the applicable SCPs allow account principals to access.
     */
    public final Integer numberOfServicesAccessible() {
        return numberOfServicesAccessible;
    }

    /**
     * <p>
     * The number of services that account principals are allowed but did not attempt to access.
     * </p>
     * 
     * @return The number of services that account principals are allowed but did not attempt to access.
     */
    public final Integer numberOfServicesNotAccessed() {
        return numberOfServicesNotAccessed;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessDetails() {
        return accessDetails != null && !(accessDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that contains details about the most recent attempt to access the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessDetails} method.
     * </p>
     * 
     * @return An object that contains details about the most recent attempt to access the service.
     */
    public final List<AccessDetail> accessDetails() {
        return accessDetails;
    }

    /**
     * <p>
     * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
     * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that
     * IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results
     * available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all
     * your results.
     * </p>
     * 
     * @return A flag that indicates whether there are more items to return. If your results were truncated, you can
     *         make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
     *         items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there
     *         are more results available. We recommend that you check <code>IsTruncated</code> after every call to
     *         ensure that you receive all your results.
     */
    public final Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the
     * <code>Marker</code> parameter in a subsequent pagination request.
     * </p>
     * 
     * @return When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use
     *         for the <code>Marker</code> parameter in a subsequent pagination request.
     */
    public final String marker() {
        return marker;
    }

    /**
     * Returns the value of the ErrorDetails property for this object.
     * 
     * @return The value of the ErrorDetails property for this object.
     */
    public final ErrorDetails errorDetails() {
        return errorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(jobCompletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfServicesAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfServicesNotAccessed());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessDetails() ? accessDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOrganizationsAccessReportResponse)) {
            return false;
        }
        GetOrganizationsAccessReportResponse other = (GetOrganizationsAccessReportResponse) obj;
        return Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(jobCreationDate(), other.jobCreationDate())
                && Objects.equals(jobCompletionDate(), other.jobCompletionDate())
                && Objects.equals(numberOfServicesAccessible(), other.numberOfServicesAccessible())
                && Objects.equals(numberOfServicesNotAccessed(), other.numberOfServicesNotAccessed())
                && hasAccessDetails() == other.hasAccessDetails() && Objects.equals(accessDetails(), other.accessDetails())
                && Objects.equals(isTruncated(), other.isTruncated()) && Objects.equals(marker(), other.marker())
                && Objects.equals(errorDetails(), other.errorDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOrganizationsAccessReportResponse").add("JobStatus", jobStatusAsString())
                .add("JobCreationDate", jobCreationDate()).add("JobCompletionDate", jobCompletionDate())
                .add("NumberOfServicesAccessible", numberOfServicesAccessible())
                .add("NumberOfServicesNotAccessed", numberOfServicesNotAccessed())
                .add("AccessDetails", hasAccessDetails() ? accessDetails() : null).add("IsTruncated", isTruncated())
                .add("Marker", marker()).add("ErrorDetails", errorDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "JobCreationDate":
            return Optional.ofNullable(clazz.cast(jobCreationDate()));
        case "JobCompletionDate":
            return Optional.ofNullable(clazz.cast(jobCompletionDate()));
        case "NumberOfServicesAccessible":
            return Optional.ofNullable(clazz.cast(numberOfServicesAccessible()));
        case "NumberOfServicesNotAccessed":
            return Optional.ofNullable(clazz.cast(numberOfServicesNotAccessed()));
        case "AccessDetails":
            return Optional.ofNullable(clazz.cast(accessDetails()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ErrorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("JobCreationDate", JOB_CREATION_DATE_FIELD);
        map.put("JobCompletionDate", JOB_COMPLETION_DATE_FIELD);
        map.put("NumberOfServicesAccessible", NUMBER_OF_SERVICES_ACCESSIBLE_FIELD);
        map.put("NumberOfServicesNotAccessed", NUMBER_OF_SERVICES_NOT_ACCESSED_FIELD);
        map.put("AccessDetails", ACCESS_DETAILS_FIELD);
        map.put("IsTruncated", IS_TRUNCATED_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("ErrorDetails", ERROR_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOrganizationsAccessReportResponse, T> g) {
        return obj -> g.apply((GetOrganizationsAccessReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetOrganizationsAccessReportResponse> {
        /**
         * <p>
         * The status of the job.
         * </p>
         * 
         * @param jobStatus
         *        The status of the job.
         * @see JobStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatusType
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The status of the job.
         * </p>
         * 
         * @param jobStatus
         *        The status of the job.
         * @see JobStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatusType
         */
        Builder jobStatus(JobStatusType jobStatus);

        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report
         * job was created.
         * </p>
         * 
         * @param jobCreationDate
         *        The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         *        report job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobCreationDate(Instant jobCreationDate);

        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         * generated report job was completed or failed.
         * </p>
         * <p>
         * This field is null if the job is still in progress, as indicated by a job status value of
         * <code>IN_PROGRESS</code>.
         * </p>
         * 
         * @param jobCompletionDate
         *        The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         *        generated report job was completed or failed.</p>
         *        <p>
         *        This field is null if the job is still in progress, as indicated by a job status value of
         *        <code>IN_PROGRESS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobCompletionDate(Instant jobCompletionDate);

        /**
         * <p>
         * The number of services that the applicable SCPs allow account principals to access.
         * </p>
         * 
         * @param numberOfServicesAccessible
         *        The number of services that the applicable SCPs allow account principals to access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfServicesAccessible(Integer numberOfServicesAccessible);

        /**
         * <p>
         * The number of services that account principals are allowed but did not attempt to access.
         * </p>
         * 
         * @param numberOfServicesNotAccessed
         *        The number of services that account principals are allowed but did not attempt to access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfServicesNotAccessed(Integer numberOfServicesNotAccessed);

        /**
         * <p>
         * An object that contains details about the most recent attempt to access the service.
         * </p>
         * 
         * @param accessDetails
         *        An object that contains details about the most recent attempt to access the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessDetails(Collection<AccessDetail> accessDetails);

        /**
         * <p>
         * An object that contains details about the most recent attempt to access the service.
         * </p>
         * 
         * @param accessDetails
         *        An object that contains details about the most recent attempt to access the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessDetails(AccessDetail... accessDetails);

        /**
         * <p>
         * An object that contains details about the most recent attempt to access the service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iam.model.AccessDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iam.model.AccessDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iam.model.AccessDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #accessDetails(List<AccessDetail>)}.
         * 
         * @param accessDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iam.model.AccessDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessDetails(java.util.Collection<AccessDetail>)
         */
        Builder accessDetails(Consumer<AccessDetail.Builder>... accessDetails);

        /**
         * <p>
         * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
         * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note
         * that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results
         * available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive
         * all your results.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more items to return. If your results were truncated, you can
         *        make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
         *        items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when
         *        there are more results available. We recommend that you check <code>IsTruncated</code> after every
         *        call to ensure that you receive all your results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for
         * the <code>Marker</code> parameter in a subsequent pagination request.
         * </p>
         * 
         * @param marker
         *        When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to
         *        use for the <code>Marker</code> parameter in a subsequent pagination request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * Sets the value of the ErrorDetails property for this object.
         *
         * @param errorDetails
         *        The new value for the ErrorDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(ErrorDetails errorDetails);

        /**
         * Sets the value of the ErrorDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ErrorDetails.Builder} avoiding the need
         * to create one manually via {@link ErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #errorDetails(ErrorDetails)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on {@link ErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(ErrorDetails)
         */
        default Builder errorDetails(Consumer<ErrorDetails.Builder> errorDetails) {
            return errorDetails(ErrorDetails.builder().applyMutation(errorDetails).build());
        }
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private String jobStatus;

        private Instant jobCreationDate;

        private Instant jobCompletionDate;

        private Integer numberOfServicesAccessible;

        private Integer numberOfServicesNotAccessed;

        private List<AccessDetail> accessDetails = DefaultSdkAutoConstructList.getInstance();

        private Boolean isTruncated;

        private String marker;

        private ErrorDetails errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOrganizationsAccessReportResponse model) {
            super(model);
            jobStatus(model.jobStatus);
            jobCreationDate(model.jobCreationDate);
            jobCompletionDate(model.jobCompletionDate);
            numberOfServicesAccessible(model.numberOfServicesAccessible);
            numberOfServicesNotAccessed(model.numberOfServicesNotAccessed);
            accessDetails(model.accessDetails);
            isTruncated(model.isTruncated);
            marker(model.marker);
            errorDetails(model.errorDetails);
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatusType jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Instant getJobCreationDate() {
            return jobCreationDate;
        }

        public final void setJobCreationDate(Instant jobCreationDate) {
            this.jobCreationDate = jobCreationDate;
        }

        @Override
        public final Builder jobCreationDate(Instant jobCreationDate) {
            this.jobCreationDate = jobCreationDate;
            return this;
        }

        public final Instant getJobCompletionDate() {
            return jobCompletionDate;
        }

        public final void setJobCompletionDate(Instant jobCompletionDate) {
            this.jobCompletionDate = jobCompletionDate;
        }

        @Override
        public final Builder jobCompletionDate(Instant jobCompletionDate) {
            this.jobCompletionDate = jobCompletionDate;
            return this;
        }

        public final Integer getNumberOfServicesAccessible() {
            return numberOfServicesAccessible;
        }

        public final void setNumberOfServicesAccessible(Integer numberOfServicesAccessible) {
            this.numberOfServicesAccessible = numberOfServicesAccessible;
        }

        @Override
        public final Builder numberOfServicesAccessible(Integer numberOfServicesAccessible) {
            this.numberOfServicesAccessible = numberOfServicesAccessible;
            return this;
        }

        public final Integer getNumberOfServicesNotAccessed() {
            return numberOfServicesNotAccessed;
        }

        public final void setNumberOfServicesNotAccessed(Integer numberOfServicesNotAccessed) {
            this.numberOfServicesNotAccessed = numberOfServicesNotAccessed;
        }

        @Override
        public final Builder numberOfServicesNotAccessed(Integer numberOfServicesNotAccessed) {
            this.numberOfServicesNotAccessed = numberOfServicesNotAccessed;
            return this;
        }

        public final List<AccessDetail.Builder> getAccessDetails() {
            List<AccessDetail.Builder> result = AccessDetailsCopier.copyToBuilder(this.accessDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessDetails(Collection<AccessDetail.BuilderImpl> accessDetails) {
            this.accessDetails = AccessDetailsCopier.copyFromBuilder(accessDetails);
        }

        @Override
        public final Builder accessDetails(Collection<AccessDetail> accessDetails) {
            this.accessDetails = AccessDetailsCopier.copy(accessDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessDetails(AccessDetail... accessDetails) {
            accessDetails(Arrays.asList(accessDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessDetails(Consumer<AccessDetail.Builder>... accessDetails) {
            accessDetails(Stream.of(accessDetails).map(c -> AccessDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final ErrorDetails.Builder getErrorDetails() {
            return errorDetails != null ? errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(ErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        @Override
        public GetOrganizationsAccessReportResponse build() {
            return new GetOrganizationsAccessReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
