/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContextKeysForCustomPolicyRequest extends IamRequest implements
        ToCopyableBuilder<GetContextKeysForCustomPolicyRequest.Builder, GetContextKeysForCustomPolicyRequest> {
    private static final SdkField<List<String>> POLICY_INPUT_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PolicyInputList")
            .getter(getter(GetContextKeysForCustomPolicyRequest::policyInputList))
            .setter(setter(Builder::policyInputList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyInputList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_INPUT_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> policyInputList;

    private GetContextKeysForCustomPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyInputList = builder.policyInputList;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyInputList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyInputList() {
        return policyInputList != null && !(policyInputList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of policies for which you want the list of context keys referenced in those policies. Each document is
     * specified as a string containing the complete, valid JSON text of an IAM policy.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of
     * characters consisting of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII
     * character range
     * </p>
     * </li>
     * <li>
     * <p>
     * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>
     * )
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyInputList} method.
     * </p>
     * 
     * @return A list of policies for which you want the list of context keys referenced in those policies. Each
     *         document is specified as a string containing the complete, valid JSON text of an IAM policy.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
     *         string of characters consisting of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of
     *         the ASCII character range
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The printable characters in the Basic Latin and Latin-1 Supplement character set (through
     *         <code>\u00FF</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
     *         <code>\u000D</code>)
     *         </p>
     *         </li>
     */
    public final List<String> policyInputList() {
        return policyInputList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyInputList() ? policyInputList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContextKeysForCustomPolicyRequest)) {
            return false;
        }
        GetContextKeysForCustomPolicyRequest other = (GetContextKeysForCustomPolicyRequest) obj;
        return hasPolicyInputList() == other.hasPolicyInputList() && Objects.equals(policyInputList(), other.policyInputList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetContextKeysForCustomPolicyRequest")
                .add("PolicyInputList", hasPolicyInputList() ? policyInputList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyInputList":
            return Optional.ofNullable(clazz.cast(policyInputList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyInputList", POLICY_INPUT_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetContextKeysForCustomPolicyRequest, T> g) {
        return obj -> g.apply((GetContextKeysForCustomPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetContextKeysForCustomPolicyRequest> {
        /**
         * <p>
         * A list of policies for which you want the list of context keys referenced in those policies. Each document is
         * specified as a string containing the complete, valid JSON text of an IAM policy.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string
         * of characters consisting of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the
         * ASCII character range
         * </p>
         * </li>
         * <li>
         * <p>
         * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
         * )
         * </p>
         * </li>
         * <li>
         * <p>
         * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
         * <code>\u000D</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param policyInputList
         *        A list of policies for which you want the list of context keys referenced in those policies. Each
         *        document is specified as a string containing the complete, valid JSON text of an IAM policy.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
         *        string of characters consisting of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end
         *        of the ASCII character range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The printable characters in the Basic Latin and Latin-1 Supplement character set (through
         *        <code>\u00FF</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return
         *        (<code>\u000D</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyInputList(Collection<String> policyInputList);

        /**
         * <p>
         * A list of policies for which you want the list of context keys referenced in those policies. Each document is
         * specified as a string containing the complete, valid JSON text of an IAM policy.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string
         * of characters consisting of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the
         * ASCII character range
         * </p>
         * </li>
         * <li>
         * <p>
         * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
         * )
         * </p>
         * </li>
         * <li>
         * <p>
         * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
         * <code>\u000D</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param policyInputList
         *        A list of policies for which you want the list of context keys referenced in those policies. Each
         *        document is specified as a string containing the complete, valid JSON text of an IAM policy.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
         *        string of characters consisting of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end
         *        of the ASCII character range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The printable characters in the Basic Latin and Latin-1 Supplement character set (through
         *        <code>\u00FF</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return
         *        (<code>\u000D</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyInputList(String... policyInputList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private List<String> policyInputList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContextKeysForCustomPolicyRequest model) {
            super(model);
            policyInputList(model.policyInputList);
        }

        public final Collection<String> getPolicyInputList() {
            if (policyInputList instanceof SdkAutoConstructList) {
                return null;
            }
            return policyInputList;
        }

        public final void setPolicyInputList(Collection<String> policyInputList) {
            this.policyInputList = SimulationPolicyListTypeCopier.copy(policyInputList);
        }

        @Override
        public final Builder policyInputList(Collection<String> policyInputList) {
            this.policyInputList = SimulationPolicyListTypeCopier.copy(policyInputList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyInputList(String... policyInputList) {
            policyInputList(Arrays.asList(policyInputList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetContextKeysForCustomPolicyRequest build() {
            return new GetContextKeysForCustomPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
