/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.model.GetInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.GetInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.GetPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetRoleRequest;
import software.amazon.awssdk.services.iam.model.GetRoleResponse;
import software.amazon.awssdk.services.iam.model.GetUserRequest;
import software.amazon.awssdk.services.iam.model.GetUserResponse;
import software.amazon.awssdk.services.iam.waiters.DefaultIamAsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
@ThreadSafe
@Immutable
public interface IamAsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<GetInstanceProfileResponse>> waitUntilInstanceProfileExists(GetInstanceProfileRequest getInstanceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetInstanceProfileResponse>> waitUntilInstanceProfileExists(Consumer<GetInstanceProfileRequest.Builder> getInstanceProfileRequest) {
        return this.waitUntilInstanceProfileExists((GetInstanceProfileRequest)((Object)((GetInstanceProfileRequest.Builder)GetInstanceProfileRequest.builder().applyMutation(getInstanceProfileRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetInstanceProfileResponse>> waitUntilInstanceProfileExists(GetInstanceProfileRequest getInstanceProfileRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetInstanceProfileResponse>> waitUntilInstanceProfileExists(Consumer<GetInstanceProfileRequest.Builder> getInstanceProfileRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilInstanceProfileExists((GetInstanceProfileRequest)((Object)((GetInstanceProfileRequest.Builder)GetInstanceProfileRequest.builder().applyMutation(getInstanceProfileRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetPolicyResponse>> waitUntilPolicyExists(GetPolicyRequest getPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetPolicyResponse>> waitUntilPolicyExists(Consumer<GetPolicyRequest.Builder> getPolicyRequest) {
        return this.waitUntilPolicyExists((GetPolicyRequest)((Object)((GetPolicyRequest.Builder)GetPolicyRequest.builder().applyMutation(getPolicyRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetPolicyResponse>> waitUntilPolicyExists(GetPolicyRequest getPolicyRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetPolicyResponse>> waitUntilPolicyExists(Consumer<GetPolicyRequest.Builder> getPolicyRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilPolicyExists((GetPolicyRequest)((Object)((GetPolicyRequest.Builder)GetPolicyRequest.builder().applyMutation(getPolicyRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetRoleResponse>> waitUntilRoleExists(GetRoleRequest getRoleRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetRoleResponse>> waitUntilRoleExists(Consumer<GetRoleRequest.Builder> getRoleRequest) {
        return this.waitUntilRoleExists((GetRoleRequest)((Object)((GetRoleRequest.Builder)GetRoleRequest.builder().applyMutation(getRoleRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetRoleResponse>> waitUntilRoleExists(GetRoleRequest getRoleRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetRoleResponse>> waitUntilRoleExists(Consumer<GetRoleRequest.Builder> getRoleRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilRoleExists((GetRoleRequest)((Object)((GetRoleRequest.Builder)GetRoleRequest.builder().applyMutation(getRoleRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetUserResponse>> waitUntilUserExists(GetUserRequest getUserRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetUserResponse>> waitUntilUserExists(Consumer<GetUserRequest.Builder> getUserRequest) {
        return this.waitUntilUserExists((GetUserRequest)((Object)((GetUserRequest.Builder)GetUserRequest.builder().applyMutation(getUserRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetUserResponse>> waitUntilUserExists(GetUserRequest getUserRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetUserResponse>> waitUntilUserExists(Consumer<GetUserRequest.Builder> getUserRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilUserExists((GetUserRequest)((Object)((GetUserRequest.Builder)GetUserRequest.builder().applyMutation(getUserRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultIamAsyncWaiter.builder();
    }

    public static IamAsyncWaiter create() {
        return DefaultIamAsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(IamAsyncClient var1);

        public IamAsyncWaiter build();
    }
}

