/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.services.iam.model.SimulationPolicyListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContextKeysForPrincipalPolicyRequest
extends IamRequest
implements ToCopyableBuilder<Builder, GetContextKeysForPrincipalPolicyRequest> {
    private static final SdkField<String> POLICY_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicySourceArn").getter(GetContextKeysForPrincipalPolicyRequest.getter(GetContextKeysForPrincipalPolicyRequest::policySourceArn)).setter(GetContextKeysForPrincipalPolicyRequest.setter(Builder::policySourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicySourceArn").build()}).build();
    private static final SdkField<List<String>> POLICY_INPUT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyInputList").getter(GetContextKeysForPrincipalPolicyRequest.getter(GetContextKeysForPrincipalPolicyRequest::policyInputList)).setter(GetContextKeysForPrincipalPolicyRequest.setter(Builder::policyInputList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyInputList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_SOURCE_ARN_FIELD, POLICY_INPUT_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetContextKeysForPrincipalPolicyRequest.memberNameToFieldInitializer();
    private final String policySourceArn;
    private final List<String> policyInputList;

    private GetContextKeysForPrincipalPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policySourceArn = builder.policySourceArn;
        this.policyInputList = builder.policyInputList;
    }

    public final String policySourceArn() {
        return this.policySourceArn;
    }

    public final boolean hasPolicyInputList() {
        return this.policyInputList != null && !(this.policyInputList instanceof SdkAutoConstructList);
    }

    public final List<String> policyInputList() {
        return this.policyInputList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policySourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyInputList() ? this.policyInputList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContextKeysForPrincipalPolicyRequest)) {
            return false;
        }
        GetContextKeysForPrincipalPolicyRequest other = (GetContextKeysForPrincipalPolicyRequest)((Object)obj);
        return Objects.equals(this.policySourceArn(), other.policySourceArn()) && this.hasPolicyInputList() == other.hasPolicyInputList() && Objects.equals(this.policyInputList(), other.policyInputList());
    }

    public final String toString() {
        return ToString.builder((String)"GetContextKeysForPrincipalPolicyRequest").add("PolicySourceArn", (Object)this.policySourceArn()).add("PolicyInputList", this.hasPolicyInputList() ? this.policyInputList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicySourceArn": {
                return Optional.ofNullable(clazz.cast(this.policySourceArn()));
            }
            case "PolicyInputList": {
                return Optional.ofNullable(clazz.cast(this.policyInputList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PolicySourceArn", POLICY_SOURCE_ARN_FIELD);
        map.put("PolicyInputList", POLICY_INPUT_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetContextKeysForPrincipalPolicyRequest, T> g) {
        return obj -> g.apply((GetContextKeysForPrincipalPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String policySourceArn;
        private List<String> policyInputList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContextKeysForPrincipalPolicyRequest model) {
            super(model);
            this.policySourceArn(model.policySourceArn);
            this.policyInputList(model.policyInputList);
        }

        public final String getPolicySourceArn() {
            return this.policySourceArn;
        }

        public final void setPolicySourceArn(String policySourceArn) {
            this.policySourceArn = policySourceArn;
        }

        @Override
        public final Builder policySourceArn(String policySourceArn) {
            this.policySourceArn = policySourceArn;
            return this;
        }

        public final Collection<String> getPolicyInputList() {
            if (this.policyInputList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.policyInputList;
        }

        public final void setPolicyInputList(Collection<String> policyInputList) {
            this.policyInputList = SimulationPolicyListTypeCopier.copy(policyInputList);
        }

        @Override
        public final Builder policyInputList(Collection<String> policyInputList) {
            this.policyInputList = SimulationPolicyListTypeCopier.copy(policyInputList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyInputList(String ... policyInputList) {
            this.policyInputList(Arrays.asList(policyInputList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetContextKeysForPrincipalPolicyRequest build() {
            return new GetContextKeysForPrincipalPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetContextKeysForPrincipalPolicyRequest> {
        public Builder policySourceArn(String var1);

        public Builder policyInputList(Collection<String> var1);

        public Builder policyInputList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

