/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.TrackedActionLastAccessed;
import software.amazon.awssdk.services.iam.model.TrackedActionsLastAccessedCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceLastAccessed
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceLastAccessed> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(ServiceLastAccessed.getter(ServiceLastAccessed::serviceName)).setter(ServiceLastAccessed.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<Instant> LAST_AUTHENTICATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastAuthenticated").getter(ServiceLastAccessed.getter(ServiceLastAccessed::lastAuthenticated)).setter(ServiceLastAccessed.setter(Builder::lastAuthenticated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAuthenticated").build()}).build();
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceNamespace").getter(ServiceLastAccessed.getter(ServiceLastAccessed::serviceNamespace)).setter(ServiceLastAccessed.setter(Builder::serviceNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()}).build();
    private static final SdkField<String> LAST_AUTHENTICATED_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastAuthenticatedEntity").getter(ServiceLastAccessed.getter(ServiceLastAccessed::lastAuthenticatedEntity)).setter(ServiceLastAccessed.setter(Builder::lastAuthenticatedEntity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAuthenticatedEntity").build()}).build();
    private static final SdkField<String> LAST_AUTHENTICATED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastAuthenticatedRegion").getter(ServiceLastAccessed.getter(ServiceLastAccessed::lastAuthenticatedRegion)).setter(ServiceLastAccessed.setter(Builder::lastAuthenticatedRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAuthenticatedRegion").build()}).build();
    private static final SdkField<Integer> TOTAL_AUTHENTICATED_ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalAuthenticatedEntities").getter(ServiceLastAccessed.getter(ServiceLastAccessed::totalAuthenticatedEntities)).setter(ServiceLastAccessed.setter(Builder::totalAuthenticatedEntities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAuthenticatedEntities").build()}).build();
    private static final SdkField<List<TrackedActionLastAccessed>> TRACKED_ACTIONS_LAST_ACCESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrackedActionsLastAccessed").getter(ServiceLastAccessed.getter(ServiceLastAccessed::trackedActionsLastAccessed)).setter(ServiceLastAccessed.setter(Builder::trackedActionsLastAccessed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackedActionsLastAccessed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrackedActionLastAccessed::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD, LAST_AUTHENTICATED_FIELD, SERVICE_NAMESPACE_FIELD, LAST_AUTHENTICATED_ENTITY_FIELD, LAST_AUTHENTICATED_REGION_FIELD, TOTAL_AUTHENTICATED_ENTITIES_FIELD, TRACKED_ACTIONS_LAST_ACCESSED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceLastAccessed.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceName;
    private final Instant lastAuthenticated;
    private final String serviceNamespace;
    private final String lastAuthenticatedEntity;
    private final String lastAuthenticatedRegion;
    private final Integer totalAuthenticatedEntities;
    private final List<TrackedActionLastAccessed> trackedActionsLastAccessed;

    private ServiceLastAccessed(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.lastAuthenticated = builder.lastAuthenticated;
        this.serviceNamespace = builder.serviceNamespace;
        this.lastAuthenticatedEntity = builder.lastAuthenticatedEntity;
        this.lastAuthenticatedRegion = builder.lastAuthenticatedRegion;
        this.totalAuthenticatedEntities = builder.totalAuthenticatedEntities;
        this.trackedActionsLastAccessed = builder.trackedActionsLastAccessed;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final Instant lastAuthenticated() {
        return this.lastAuthenticated;
    }

    public final String serviceNamespace() {
        return this.serviceNamespace;
    }

    public final String lastAuthenticatedEntity() {
        return this.lastAuthenticatedEntity;
    }

    public final String lastAuthenticatedRegion() {
        return this.lastAuthenticatedRegion;
    }

    public final Integer totalAuthenticatedEntities() {
        return this.totalAuthenticatedEntities;
    }

    public final boolean hasTrackedActionsLastAccessed() {
        return this.trackedActionsLastAccessed != null && !(this.trackedActionsLastAccessed instanceof SdkAutoConstructList);
    }

    public final List<TrackedActionLastAccessed> trackedActionsLastAccessed() {
        return this.trackedActionsLastAccessed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAuthenticated());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAuthenticatedEntity());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAuthenticatedRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAuthenticatedEntities());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrackedActionsLastAccessed() ? this.trackedActionsLastAccessed() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLastAccessed)) {
            return false;
        }
        ServiceLastAccessed other = (ServiceLastAccessed)obj;
        return Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.lastAuthenticated(), other.lastAuthenticated()) && Objects.equals(this.serviceNamespace(), other.serviceNamespace()) && Objects.equals(this.lastAuthenticatedEntity(), other.lastAuthenticatedEntity()) && Objects.equals(this.lastAuthenticatedRegion(), other.lastAuthenticatedRegion()) && Objects.equals(this.totalAuthenticatedEntities(), other.totalAuthenticatedEntities()) && this.hasTrackedActionsLastAccessed() == other.hasTrackedActionsLastAccessed() && Objects.equals(this.trackedActionsLastAccessed(), other.trackedActionsLastAccessed());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceLastAccessed").add("ServiceName", (Object)this.serviceName()).add("LastAuthenticated", (Object)this.lastAuthenticated()).add("ServiceNamespace", (Object)this.serviceNamespace()).add("LastAuthenticatedEntity", (Object)this.lastAuthenticatedEntity()).add("LastAuthenticatedRegion", (Object)this.lastAuthenticatedRegion()).add("TotalAuthenticatedEntities", (Object)this.totalAuthenticatedEntities()).add("TrackedActionsLastAccessed", this.hasTrackedActionsLastAccessed() ? this.trackedActionsLastAccessed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "LastAuthenticated": {
                return Optional.ofNullable(clazz.cast(this.lastAuthenticated()));
            }
            case "ServiceNamespace": {
                return Optional.ofNullable(clazz.cast(this.serviceNamespace()));
            }
            case "LastAuthenticatedEntity": {
                return Optional.ofNullable(clazz.cast(this.lastAuthenticatedEntity()));
            }
            case "LastAuthenticatedRegion": {
                return Optional.ofNullable(clazz.cast(this.lastAuthenticatedRegion()));
            }
            case "TotalAuthenticatedEntities": {
                return Optional.ofNullable(clazz.cast(this.totalAuthenticatedEntities()));
            }
            case "TrackedActionsLastAccessed": {
                return Optional.ofNullable(clazz.cast(this.trackedActionsLastAccessed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("LastAuthenticated", LAST_AUTHENTICATED_FIELD);
        map.put("ServiceNamespace", SERVICE_NAMESPACE_FIELD);
        map.put("LastAuthenticatedEntity", LAST_AUTHENTICATED_ENTITY_FIELD);
        map.put("LastAuthenticatedRegion", LAST_AUTHENTICATED_REGION_FIELD);
        map.put("TotalAuthenticatedEntities", TOTAL_AUTHENTICATED_ENTITIES_FIELD);
        map.put("TrackedActionsLastAccessed", TRACKED_ACTIONS_LAST_ACCESSED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceLastAccessed, T> g) {
        return obj -> g.apply((ServiceLastAccessed)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceName;
        private Instant lastAuthenticated;
        private String serviceNamespace;
        private String lastAuthenticatedEntity;
        private String lastAuthenticatedRegion;
        private Integer totalAuthenticatedEntities;
        private List<TrackedActionLastAccessed> trackedActionsLastAccessed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLastAccessed model) {
            this.serviceName(model.serviceName);
            this.lastAuthenticated(model.lastAuthenticated);
            this.serviceNamespace(model.serviceNamespace);
            this.lastAuthenticatedEntity(model.lastAuthenticatedEntity);
            this.lastAuthenticatedRegion(model.lastAuthenticatedRegion);
            this.totalAuthenticatedEntities(model.totalAuthenticatedEntities);
            this.trackedActionsLastAccessed(model.trackedActionsLastAccessed);
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final Instant getLastAuthenticated() {
            return this.lastAuthenticated;
        }

        public final void setLastAuthenticated(Instant lastAuthenticated) {
            this.lastAuthenticated = lastAuthenticated;
        }

        @Override
        public final Builder lastAuthenticated(Instant lastAuthenticated) {
            this.lastAuthenticated = lastAuthenticated;
            return this;
        }

        public final String getServiceNamespace() {
            return this.serviceNamespace;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        public final String getLastAuthenticatedEntity() {
            return this.lastAuthenticatedEntity;
        }

        public final void setLastAuthenticatedEntity(String lastAuthenticatedEntity) {
            this.lastAuthenticatedEntity = lastAuthenticatedEntity;
        }

        @Override
        public final Builder lastAuthenticatedEntity(String lastAuthenticatedEntity) {
            this.lastAuthenticatedEntity = lastAuthenticatedEntity;
            return this;
        }

        public final String getLastAuthenticatedRegion() {
            return this.lastAuthenticatedRegion;
        }

        public final void setLastAuthenticatedRegion(String lastAuthenticatedRegion) {
            this.lastAuthenticatedRegion = lastAuthenticatedRegion;
        }

        @Override
        public final Builder lastAuthenticatedRegion(String lastAuthenticatedRegion) {
            this.lastAuthenticatedRegion = lastAuthenticatedRegion;
            return this;
        }

        public final Integer getTotalAuthenticatedEntities() {
            return this.totalAuthenticatedEntities;
        }

        public final void setTotalAuthenticatedEntities(Integer totalAuthenticatedEntities) {
            this.totalAuthenticatedEntities = totalAuthenticatedEntities;
        }

        @Override
        public final Builder totalAuthenticatedEntities(Integer totalAuthenticatedEntities) {
            this.totalAuthenticatedEntities = totalAuthenticatedEntities;
            return this;
        }

        public final List<TrackedActionLastAccessed.Builder> getTrackedActionsLastAccessed() {
            List<TrackedActionLastAccessed.Builder> result = TrackedActionsLastAccessedCopier.copyToBuilder(this.trackedActionsLastAccessed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrackedActionsLastAccessed(Collection<TrackedActionLastAccessed.BuilderImpl> trackedActionsLastAccessed) {
            this.trackedActionsLastAccessed = TrackedActionsLastAccessedCopier.copyFromBuilder(trackedActionsLastAccessed);
        }

        @Override
        public final Builder trackedActionsLastAccessed(Collection<TrackedActionLastAccessed> trackedActionsLastAccessed) {
            this.trackedActionsLastAccessed = TrackedActionsLastAccessedCopier.copy(trackedActionsLastAccessed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trackedActionsLastAccessed(TrackedActionLastAccessed ... trackedActionsLastAccessed) {
            this.trackedActionsLastAccessed(Arrays.asList(trackedActionsLastAccessed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trackedActionsLastAccessed(Consumer<TrackedActionLastAccessed.Builder> ... trackedActionsLastAccessed) {
            this.trackedActionsLastAccessed(Stream.of(trackedActionsLastAccessed).map(c -> (TrackedActionLastAccessed)((TrackedActionLastAccessed.Builder)TrackedActionLastAccessed.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ServiceLastAccessed build() {
            return new ServiceLastAccessed(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceLastAccessed> {
        public Builder serviceName(String var1);

        public Builder lastAuthenticated(Instant var1);

        public Builder serviceNamespace(String var1);

        public Builder lastAuthenticatedEntity(String var1);

        public Builder lastAuthenticatedRegion(String var1);

        public Builder totalAuthenticatedEntities(Integer var1);

        public Builder trackedActionsLastAccessed(Collection<TrackedActionLastAccessed> var1);

        public Builder trackedActionsLastAccessed(TrackedActionLastAccessed ... var1);

        public Builder trackedActionsLastAccessed(Consumer<TrackedActionLastAccessed.Builder> ... var1);
    }
}

