/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest;
import software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesResponse;
import software.amazon.awssdk.services.iam.model.VirtualMFADevice;

public class ListVirtualMFADevicesIterable
implements SdkIterable<ListVirtualMfaDevicesResponse> {
    private final IamClient client;
    private final ListVirtualMfaDevicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVirtualMFADevicesIterable(IamClient client, ListVirtualMfaDevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListVirtualMfaDevicesResponseFetcher();
    }

    public Iterator<ListVirtualMfaDevicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VirtualMFADevice> virtualMFADevices() {
        Function<ListVirtualMfaDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.virtualMFADevices() != null) {
                return response.virtualMFADevices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListVirtualMFADevicesIterable resume(ListVirtualMfaDevicesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListVirtualMFADevicesIterable(this.client, (ListVirtualMfaDevicesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListVirtualMFADevicesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListVirtualMfaDevicesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListVirtualMfaDevicesResponseFetcher
    implements SyncPageFetcher<ListVirtualMfaDevicesResponse> {
        private ListVirtualMfaDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListVirtualMfaDevicesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListVirtualMfaDevicesResponse nextPage(ListVirtualMfaDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListVirtualMFADevicesIterable.this.client.listVirtualMFADevices(ListVirtualMFADevicesIterable.this.firstRequest);
            }
            return ListVirtualMFADevicesIterable.this.client.listVirtualMFADevices((ListVirtualMfaDevicesRequest)((Object)ListVirtualMFADevicesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

