/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model._accountAliasListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccountAliasesResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListAccountAliasesResponse> {
    private static final SdkField<List<String>> ACCOUNT_ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountAliases").getter(ListAccountAliasesResponse.getter(ListAccountAliasesResponse::accountAliases)).setter(ListAccountAliasesResponse.setter(Builder::accountAliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTruncated").getter(ListAccountAliasesResponse.getter(ListAccountAliasesResponse::isTruncated)).setter(ListAccountAliasesResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListAccountAliasesResponse.getter(ListAccountAliasesResponse::marker)).setter(ListAccountAliasesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ALIASES_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountAliases", ACCOUNT_ALIASES_FIELD);
            this.put("IsTruncated", IS_TRUNCATED_FIELD);
            this.put("Marker", MARKER_FIELD);
        }
    });
    private final List<String> accountAliases;
    private final Boolean isTruncated;
    private final String marker;

    private ListAccountAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.accountAliases = builder.accountAliases;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public final boolean hasAccountAliases() {
        return this.accountAliases != null && !(this.accountAliases instanceof SdkAutoConstructList);
    }

    public final List<String> accountAliases() {
        return this.accountAliases;
    }

    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountAliases() ? this.accountAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountAliasesResponse)) {
            return false;
        }
        ListAccountAliasesResponse other = (ListAccountAliasesResponse)((Object)obj);
        return this.hasAccountAliases() == other.hasAccountAliases() && Objects.equals(this.accountAliases(), other.accountAliases()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccountAliasesResponse").add("AccountAliases", this.hasAccountAliases() ? this.accountAliases() : null).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountAliases": {
                return Optional.ofNullable(clazz.cast(this.accountAliases()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAccountAliasesResponse, T> g) {
        return obj -> g.apply((ListAccountAliasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<String> accountAliases = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountAliasesResponse model) {
            super(model);
            this.accountAliases(model.accountAliases);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<String> getAccountAliases() {
            if (this.accountAliases instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountAliases;
        }

        public final void setAccountAliases(Collection<String> accountAliases) {
            this.accountAliases = _accountAliasListTypeCopier.copy(accountAliases);
        }

        @Override
        public final Builder accountAliases(Collection<String> accountAliases) {
            this.accountAliases = _accountAliasListTypeCopier.copy(accountAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAliases(String ... accountAliases) {
            this.accountAliases(Arrays.asList(accountAliases));
            return this;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListAccountAliasesResponse build() {
            return new ListAccountAliasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccountAliasesResponse> {
        public Builder accountAliases(Collection<String> var1);

        public Builder accountAliases(String ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

