/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.EntityType;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.services.iam.model.PolicyUsageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEntitiesForPolicyRequest
extends IamRequest
implements ToCopyableBuilder<Builder, ListEntitiesForPolicyRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyArn").getter(ListEntitiesForPolicyRequest.getter(ListEntitiesForPolicyRequest::policyArn)).setter(ListEntitiesForPolicyRequest.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()}).build();
    private static final SdkField<String> ENTITY_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityFilter").getter(ListEntitiesForPolicyRequest.getter(ListEntitiesForPolicyRequest::entityFilterAsString)).setter(ListEntitiesForPolicyRequest.setter(Builder::entityFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityFilter").build()}).build();
    private static final SdkField<String> PATH_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PathPrefix").getter(ListEntitiesForPolicyRequest.getter(ListEntitiesForPolicyRequest::pathPrefix)).setter(ListEntitiesForPolicyRequest.setter(Builder::pathPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathPrefix").build()}).build();
    private static final SdkField<String> POLICY_USAGE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyUsageFilter").getter(ListEntitiesForPolicyRequest.getter(ListEntitiesForPolicyRequest::policyUsageFilterAsString)).setter(ListEntitiesForPolicyRequest.setter(Builder::policyUsageFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyUsageFilter").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListEntitiesForPolicyRequest.getter(ListEntitiesForPolicyRequest::marker)).setter(ListEntitiesForPolicyRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(ListEntitiesForPolicyRequest.getter(ListEntitiesForPolicyRequest::maxItems)).setter(ListEntitiesForPolicyRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, ENTITY_FILTER_FIELD, PATH_PREFIX_FIELD, POLICY_USAGE_FILTER_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PolicyArn", POLICY_ARN_FIELD);
            this.put("EntityFilter", ENTITY_FILTER_FIELD);
            this.put("PathPrefix", PATH_PREFIX_FIELD);
            this.put("PolicyUsageFilter", POLICY_USAGE_FILTER_FIELD);
            this.put("Marker", MARKER_FIELD);
            this.put("MaxItems", MAX_ITEMS_FIELD);
        }
    });
    private final String policyArn;
    private final String entityFilter;
    private final String pathPrefix;
    private final String policyUsageFilter;
    private final String marker;
    private final Integer maxItems;

    private ListEntitiesForPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.entityFilter = builder.entityFilter;
        this.pathPrefix = builder.pathPrefix;
        this.policyUsageFilter = builder.policyUsageFilter;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final EntityType entityFilter() {
        return EntityType.fromValue(this.entityFilter);
    }

    public final String entityFilterAsString() {
        return this.entityFilter;
    }

    public final String pathPrefix() {
        return this.pathPrefix;
    }

    public final PolicyUsageType policyUsageFilter() {
        return PolicyUsageType.fromValue(this.policyUsageFilter);
    }

    public final String policyUsageFilterAsString() {
        return this.policyUsageFilter;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyUsageFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesForPolicyRequest)) {
            return false;
        }
        ListEntitiesForPolicyRequest other = (ListEntitiesForPolicyRequest)((Object)obj);
        return Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.entityFilterAsString(), other.entityFilterAsString()) && Objects.equals(this.pathPrefix(), other.pathPrefix()) && Objects.equals(this.policyUsageFilterAsString(), other.policyUsageFilterAsString()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public final String toString() {
        return ToString.builder((String)"ListEntitiesForPolicyRequest").add("PolicyArn", (Object)this.policyArn()).add("EntityFilter", (Object)this.entityFilterAsString()).add("PathPrefix", (Object)this.pathPrefix()).add("PolicyUsageFilter", (Object)this.policyUsageFilterAsString()).add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "EntityFilter": {
                return Optional.ofNullable(clazz.cast(this.entityFilterAsString()));
            }
            case "PathPrefix": {
                return Optional.ofNullable(clazz.cast(this.pathPrefix()));
            }
            case "PolicyUsageFilter": {
                return Optional.ofNullable(clazz.cast(this.policyUsageFilterAsString()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListEntitiesForPolicyRequest, T> g) {
        return obj -> g.apply((ListEntitiesForPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String policyArn;
        private String entityFilter;
        private String pathPrefix;
        private String policyUsageFilter;
        private String marker;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitiesForPolicyRequest model) {
            super(model);
            this.policyArn(model.policyArn);
            this.entityFilter(model.entityFilter);
            this.pathPrefix(model.pathPrefix);
            this.policyUsageFilter(model.policyUsageFilter);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getEntityFilter() {
            return this.entityFilter;
        }

        public final void setEntityFilter(String entityFilter) {
            this.entityFilter = entityFilter;
        }

        @Override
        public final Builder entityFilter(String entityFilter) {
            this.entityFilter = entityFilter;
            return this;
        }

        @Override
        public final Builder entityFilter(EntityType entityFilter) {
            this.entityFilter(entityFilter == null ? null : entityFilter.toString());
            return this;
        }

        public final String getPathPrefix() {
            return this.pathPrefix;
        }

        public final void setPathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        @Override
        public final Builder pathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
            return this;
        }

        public final String getPolicyUsageFilter() {
            return this.policyUsageFilter;
        }

        public final void setPolicyUsageFilter(String policyUsageFilter) {
            this.policyUsageFilter = policyUsageFilter;
        }

        @Override
        public final Builder policyUsageFilter(String policyUsageFilter) {
            this.policyUsageFilter = policyUsageFilter;
            return this;
        }

        @Override
        public final Builder policyUsageFilter(PolicyUsageType policyUsageFilter) {
            this.policyUsageFilter(policyUsageFilter == null ? null : policyUsageFilter.toString());
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEntitiesForPolicyRequest build() {
            return new ListEntitiesForPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEntitiesForPolicyRequest> {
        public Builder policyArn(String var1);

        public Builder entityFilter(String var1);

        public Builder entityFilter(EntityType var1);

        public Builder pathPrefix(String var1);

        public Builder policyUsageFilter(String var1);

        public Builder policyUsageFilter(PolicyUsageType var1);

        public Builder marker(String var1);

        public Builder maxItems(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

