/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse;

public class ListRolePoliciesIterable
implements SdkIterable<ListRolePoliciesResponse> {
    private final IamClient client;
    private final ListRolePoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRolePoliciesIterable(IamClient client, ListRolePoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRolePoliciesResponseFetcher();
    }

    public Iterator<ListRolePoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> policyNames() {
        Function<ListRolePoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyNames() != null) {
                return response.policyNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRolePoliciesResponseFetcher
    implements SyncPageFetcher<ListRolePoliciesResponse> {
        private ListRolePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListRolePoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListRolePoliciesResponse nextPage(ListRolePoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListRolePoliciesIterable.this.client.listRolePolicies(ListRolePoliciesIterable.this.firstRequest);
            }
            return ListRolePoliciesIterable.this.client.listRolePolicies((ListRolePoliciesRequest)((Object)ListRolePoliciesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

