/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsRequest;
import software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsResponse;
import software.amazon.awssdk.services.iam.model.Tag;

public class ListOpenIDConnectProviderTagsIterable
implements SdkIterable<ListOpenIdConnectProviderTagsResponse> {
    private final IamClient client;
    private final ListOpenIdConnectProviderTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOpenIDConnectProviderTagsIterable(IamClient client, ListOpenIdConnectProviderTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOpenIdConnectProviderTagsResponseFetcher();
    }

    public Iterator<ListOpenIdConnectProviderTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Tag> tags() {
        Function<ListOpenIdConnectProviderTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOpenIdConnectProviderTagsResponseFetcher
    implements SyncPageFetcher<ListOpenIdConnectProviderTagsResponse> {
        private ListOpenIdConnectProviderTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListOpenIdConnectProviderTagsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListOpenIdConnectProviderTagsResponse nextPage(ListOpenIdConnectProviderTagsResponse previousPage) {
            if (previousPage == null) {
                return ListOpenIDConnectProviderTagsIterable.this.client.listOpenIDConnectProviderTags(ListOpenIDConnectProviderTagsIterable.this.firstRequest);
            }
            return ListOpenIDConnectProviderTagsIterable.this.client.listOpenIDConnectProviderTags((ListOpenIdConnectProviderTagsRequest)((Object)ListOpenIDConnectProviderTagsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

