/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.EvaluationResult;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyRequest;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyResponse;

public class SimulateCustomPolicyIterable
implements SdkIterable<SimulateCustomPolicyResponse> {
    private final IamClient client;
    private final SimulateCustomPolicyRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SimulateCustomPolicyIterable(IamClient client, SimulateCustomPolicyRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SimulateCustomPolicyResponseFetcher();
    }

    public Iterator<SimulateCustomPolicyResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EvaluationResult> evaluationResults() {
        Function<SimulateCustomPolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.evaluationResults() != null) {
                return response.evaluationResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SimulateCustomPolicyResponseFetcher
    implements SyncPageFetcher<SimulateCustomPolicyResponse> {
        private SimulateCustomPolicyResponseFetcher() {
        }

        public boolean hasNextPage(SimulateCustomPolicyResponse previousPage) {
            return previousPage.isTruncated();
        }

        public SimulateCustomPolicyResponse nextPage(SimulateCustomPolicyResponse previousPage) {
            if (previousPage == null) {
                return SimulateCustomPolicyIterable.this.client.simulateCustomPolicy(SimulateCustomPolicyIterable.this.firstRequest);
            }
            return SimulateCustomPolicyIterable.this.client.simulateCustomPolicy((SimulateCustomPolicyRequest)((Object)SimulateCustomPolicyIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

