/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.EvaluationResult;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyRequest;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyResponse;

public class SimulatePrincipalPolicyIterable
implements SdkIterable<SimulatePrincipalPolicyResponse> {
    private final IamClient client;
    private final SimulatePrincipalPolicyRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SimulatePrincipalPolicyIterable(IamClient client, SimulatePrincipalPolicyRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SimulatePrincipalPolicyResponseFetcher();
    }

    public Iterator<SimulatePrincipalPolicyResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EvaluationResult> evaluationResults() {
        Function<SimulatePrincipalPolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.evaluationResults() != null) {
                return response.evaluationResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SimulatePrincipalPolicyResponseFetcher
    implements SyncPageFetcher<SimulatePrincipalPolicyResponse> {
        private SimulatePrincipalPolicyResponseFetcher() {
        }

        public boolean hasNextPage(SimulatePrincipalPolicyResponse previousPage) {
            return previousPage.isTruncated();
        }

        public SimulatePrincipalPolicyResponse nextPage(SimulatePrincipalPolicyResponse previousPage) {
            if (previousPage == null) {
                return SimulatePrincipalPolicyIterable.this.client.simulatePrincipalPolicy(SimulatePrincipalPolicyIterable.this.firstRequest);
            }
            return SimulatePrincipalPolicyIterable.this.client.simulatePrincipalPolicy((SimulatePrincipalPolicyRequest)((Object)SimulatePrincipalPolicyIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

