/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.interceptor.GlobalServiceExecutionInterceptor;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.protocols.query.interceptor.QueryParametersToBodyInterceptor;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iam.DefaultIamBaseClientBuilder;
import software.amazon.awssdk.services.iam.DefaultIamClient;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.IamClientBuilder;
import software.amazon.awssdk.services.iam.IamServiceClientConfiguration;
import software.amazon.awssdk.services.iam.endpoints.IamEndpointProvider;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
final class DefaultIamClientBuilder
extends DefaultIamBaseClientBuilder<IamClientBuilder, IamClient>
implements IamClientBuilder {
    DefaultIamClientBuilder() {
    }

    @Override
    public DefaultIamClientBuilder endpointProvider(IamEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IamClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        List interceptors = (List)clientConfiguration.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS);
        List<QueryParametersToBodyInterceptor> queryParamsToBodyInterceptor = Collections.singletonList(new QueryParametersToBodyInterceptor());
        ArrayList<GlobalServiceExecutionInterceptor> customizationInterceptors = new ArrayList<GlobalServiceExecutionInterceptor>();
        customizationInterceptors.add(new GlobalServiceExecutionInterceptor());
        interceptors = CollectionUtils.mergeLists(queryParamsToBodyInterceptor, (List)interceptors);
        interceptors = CollectionUtils.mergeLists(customizationInterceptors, (List)interceptors);
        clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors).build();
        DefaultIamClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        IamServiceClientConfiguration serviceClientConfiguration = IamServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultIamClient(serviceClientConfiguration, clientConfiguration);
    }
}

