/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PolicyScopeType {
    ALL("All"),
    AWS("AWS"),
    LOCAL("Local"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PolicyScopeType> VALUE_MAP;
    private final String value;

    private PolicyScopeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PolicyScopeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PolicyScopeType> knownValues() {
        EnumSet<PolicyScopeType> knownValues = EnumSet.allOf(PolicyScopeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PolicyScopeType.class, PolicyScopeType::toString);
    }
}

