/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iam.DefaultIamAsyncClient;
import software.amazon.awssdk.services.iam.DefaultIamBaseClientBuilder;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.IamAsyncClientBuilder;
import software.amazon.awssdk.services.iam.IamServiceClientConfiguration;
import software.amazon.awssdk.services.iam.endpoints.IamEndpointProvider;

@SdkInternalApi
final class DefaultIamAsyncClientBuilder
extends DefaultIamBaseClientBuilder<IamAsyncClientBuilder, IamAsyncClient>
implements IamAsyncClientBuilder {
    DefaultIamAsyncClientBuilder() {
    }

    @Override
    public DefaultIamAsyncClientBuilder endpointProvider(IamEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IamAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultIamAsyncClientBuilder.validateClientOptions(clientConfiguration);
        IamServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIamAsyncClient client = new DefaultIamAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IamServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IamServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

