/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListSigningCertificatesRequest;
import software.amazon.awssdk.services.iam.model.ListSigningCertificatesResponse;
import software.amazon.awssdk.services.iam.model.SigningCertificate;

public class ListSigningCertificatesIterable
implements SdkIterable<ListSigningCertificatesResponse> {
    private final IamClient client;
    private final ListSigningCertificatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSigningCertificatesIterable(IamClient client, ListSigningCertificatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSigningCertificatesResponseFetcher();
    }

    public Iterator<ListSigningCertificatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SigningCertificate> certificates() {
        Function<ListSigningCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.certificates() != null) {
                return response.certificates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSigningCertificatesResponseFetcher
    implements SyncPageFetcher<ListSigningCertificatesResponse> {
        private ListSigningCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(ListSigningCertificatesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListSigningCertificatesResponse nextPage(ListSigningCertificatesResponse previousPage) {
            if (previousPage == null) {
                return ListSigningCertificatesIterable.this.client.listSigningCertificates(ListSigningCertificatesIterable.this.firstRequest);
            }
            return ListSigningCertificatesIterable.this.client.listSigningCertificates((ListSigningCertificatesRequest)((Object)ListSigningCertificatesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

