/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.awscore.AwsResponseMetadata;
import software.amazon.awssdk.services.iam.model.IamResponseMetadata;

public abstract class IamResponse
extends AwsResponse {
    private final IamResponseMetadata responseMetadata;

    protected IamResponse(Builder builder) {
        super((AwsResponse.Builder)builder);
        this.responseMetadata = builder.responseMetadata();
    }

    public IamResponseMetadata responseMetadata() {
        return this.responseMetadata;
    }

    protected static abstract class BuilderImpl
    extends AwsResponse.BuilderImpl
    implements Builder {
        private IamResponseMetadata responseMetadata;

        protected BuilderImpl() {
        }

        protected BuilderImpl(IamResponse response) {
            super((AwsResponse)response);
            this.responseMetadata = response.responseMetadata();
        }

        @Override
        public IamResponseMetadata responseMetadata() {
            return this.responseMetadata;
        }

        @Override
        public Builder responseMetadata(AwsResponseMetadata responseMetadata) {
            this.responseMetadata = IamResponseMetadata.create(responseMetadata);
            return this;
        }
    }

    public static interface Builder
    extends AwsResponse.Builder {
        public IamResponse build();

        public IamResponseMetadata responseMetadata();

        public Builder responseMetadata(AwsResponseMetadata var1);
    }
}

