/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePolicyVersionRequest
extends IamRequest
implements ToCopyableBuilder<Builder, CreatePolicyVersionRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyArn").getter(CreatePolicyVersionRequest.getter(CreatePolicyVersionRequest::policyArn)).setter(CreatePolicyVersionRequest.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyDocument").getter(CreatePolicyVersionRequest.getter(CreatePolicyVersionRequest::policyDocument)).setter(CreatePolicyVersionRequest.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").build()}).build();
    private static final SdkField<Boolean> SET_AS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SetAsDefault").getter(CreatePolicyVersionRequest.getter(CreatePolicyVersionRequest::setAsDefault)).setter(CreatePolicyVersionRequest.setter(Builder::setAsDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SetAsDefault").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, POLICY_DOCUMENT_FIELD, SET_AS_DEFAULT_FIELD));
    private final String policyArn;
    private final String policyDocument;
    private final Boolean setAsDefault;

    private CreatePolicyVersionRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.policyDocument = builder.policyDocument;
        this.setAsDefault = builder.setAsDefault;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public final Boolean setAsDefault() {
        return this.setAsDefault;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.setAsDefault());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePolicyVersionRequest)) {
            return false;
        }
        CreatePolicyVersionRequest other = (CreatePolicyVersionRequest)((Object)obj);
        return Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.setAsDefault(), other.setAsDefault());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePolicyVersionRequest").add("PolicyArn", (Object)this.policyArn()).add("PolicyDocument", (Object)this.policyDocument()).add("SetAsDefault", (Object)this.setAsDefault()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "SetAsDefault": {
                return Optional.ofNullable(clazz.cast(this.setAsDefault()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePolicyVersionRequest, T> g) {
        return obj -> g.apply((CreatePolicyVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String policyArn;
        private String policyDocument;
        private Boolean setAsDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePolicyVersionRequest model) {
            super(model);
            this.policyArn(model.policyArn);
            this.policyDocument(model.policyDocument);
            this.setAsDefault(model.setAsDefault);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final Boolean getSetAsDefault() {
            return this.setAsDefault;
        }

        public final void setSetAsDefault(Boolean setAsDefault) {
            this.setAsDefault = setAsDefault;
        }

        @Override
        @Transient
        public final Builder setAsDefault(Boolean setAsDefault) {
            this.setAsDefault = setAsDefault;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePolicyVersionRequest build() {
            return new CreatePolicyVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePolicyVersionRequest> {
        public Builder policyArn(String var1);

        public Builder policyDocument(String var1);

        public Builder setAsDefault(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

