/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReportStateType {
    STARTED("STARTED"),
    INPROGRESS("INPROGRESS"),
    COMPLETE("COMPLETE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReportStateType> VALUE_MAP;
    private final String value;

    private ReportStateType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReportStateType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReportStateType> knownValues() {
        EnumSet<ReportStateType> knownValues = EnumSet.allOf(ReportStateType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReportStateType.class, ReportStateType::toString);
    }
}

