/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.EntityInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityDetails> {
    private static final SdkField<EntityInfo> ENTITY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EntityInfo").getter(EntityDetails.getter(EntityDetails::entityInfo)).setter(EntityDetails.setter(Builder::entityInfo)).constructor(EntityInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityInfo").build()}).build();
    private static final SdkField<Instant> LAST_AUTHENTICATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastAuthenticated").getter(EntityDetails.getter(EntityDetails::lastAuthenticated)).setter(EntityDetails.setter(Builder::lastAuthenticated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAuthenticated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_INFO_FIELD, LAST_AUTHENTICATED_FIELD));
    private static final long serialVersionUID = 1L;
    private final EntityInfo entityInfo;
    private final Instant lastAuthenticated;

    private EntityDetails(BuilderImpl builder) {
        this.entityInfo = builder.entityInfo;
        this.lastAuthenticated = builder.lastAuthenticated;
    }

    public final EntityInfo entityInfo() {
        return this.entityInfo;
    }

    public final Instant lastAuthenticated() {
        return this.lastAuthenticated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAuthenticated());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityDetails)) {
            return false;
        }
        EntityDetails other = (EntityDetails)obj;
        return Objects.equals(this.entityInfo(), other.entityInfo()) && Objects.equals(this.lastAuthenticated(), other.lastAuthenticated());
    }

    public final String toString() {
        return ToString.builder((String)"EntityDetails").add("EntityInfo", (Object)this.entityInfo()).add("LastAuthenticated", (Object)this.lastAuthenticated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityInfo": {
                return Optional.ofNullable(clazz.cast(this.entityInfo()));
            }
            case "LastAuthenticated": {
                return Optional.ofNullable(clazz.cast(this.lastAuthenticated()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityDetails, T> g) {
        return obj -> g.apply((EntityDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EntityInfo entityInfo;
        private Instant lastAuthenticated;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityDetails model) {
            this.entityInfo(model.entityInfo);
            this.lastAuthenticated(model.lastAuthenticated);
        }

        public final EntityInfo.Builder getEntityInfo() {
            return this.entityInfo != null ? this.entityInfo.toBuilder() : null;
        }

        public final void setEntityInfo(EntityInfo.BuilderImpl entityInfo) {
            this.entityInfo = entityInfo != null ? entityInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder entityInfo(EntityInfo entityInfo) {
            this.entityInfo = entityInfo;
            return this;
        }

        public final Instant getLastAuthenticated() {
            return this.lastAuthenticated;
        }

        public final void setLastAuthenticated(Instant lastAuthenticated) {
            this.lastAuthenticated = lastAuthenticated;
        }

        @Override
        @Transient
        public final Builder lastAuthenticated(Instant lastAuthenticated) {
            this.lastAuthenticated = lastAuthenticated;
            return this;
        }

        public EntityDetails build() {
            return new EntityDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityDetails> {
        public Builder entityInfo(EntityInfo var1);

        default public Builder entityInfo(Consumer<EntityInfo.Builder> entityInfo) {
            return this.entityInfo((EntityInfo)((EntityInfo.Builder)EntityInfo.builder().applyMutation(entityInfo)).build());
        }

        public Builder lastAuthenticated(Instant var1);
    }
}

