/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest;
import software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse;

public class ListAccountAliasesIterable
implements SdkIterable<ListAccountAliasesResponse> {
    private final IamClient client;
    private final ListAccountAliasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountAliasesIterable(IamClient client, ListAccountAliasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAccountAliasesResponseFetcher();
    }

    public Iterator<ListAccountAliasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> accountAliases() {
        Function<ListAccountAliasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountAliases() != null) {
                return response.accountAliases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccountAliasesResponseFetcher
    implements SyncPageFetcher<ListAccountAliasesResponse> {
        private ListAccountAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountAliasesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListAccountAliasesResponse nextPage(ListAccountAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListAccountAliasesIterable.this.client.listAccountAliases(ListAccountAliasesIterable.this.firstRequest);
            }
            return ListAccountAliasesIterable.this.client.listAccountAliases((ListAccountAliasesRequest)((Object)ListAccountAliasesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

