/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.VirtualMFADevice;
import software.amazon.awssdk.services.iam.model._virtualMFADeviceListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVirtualMfaDevicesResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListVirtualMfaDevicesResponse> {
    private static final SdkField<List<VirtualMFADevice>> VIRTUAL_MFA_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VirtualMFADevices").getter(ListVirtualMfaDevicesResponse.getter(ListVirtualMfaDevicesResponse::virtualMFADevices)).setter(ListVirtualMfaDevicesResponse.setter(Builder::virtualMFADevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualMFADevices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VirtualMFADevice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTruncated").getter(ListVirtualMfaDevicesResponse.getter(ListVirtualMfaDevicesResponse::isTruncated)).setter(ListVirtualMfaDevicesResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListVirtualMfaDevicesResponse.getter(ListVirtualMfaDevicesResponse::marker)).setter(ListVirtualMfaDevicesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_MFA_DEVICES_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD));
    private final List<VirtualMFADevice> virtualMFADevices;
    private final Boolean isTruncated;
    private final String marker;

    private ListVirtualMfaDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.virtualMFADevices = builder.virtualMFADevices;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public boolean hasVirtualMFADevices() {
        return this.virtualMFADevices != null && !(this.virtualMFADevices instanceof SdkAutoConstructList);
    }

    public List<VirtualMFADevice> virtualMFADevices() {
        return this.virtualMFADevices;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVirtualMFADevices() ? this.virtualMFADevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualMfaDevicesResponse)) {
            return false;
        }
        ListVirtualMfaDevicesResponse other = (ListVirtualMfaDevicesResponse)((Object)obj);
        return this.hasVirtualMFADevices() == other.hasVirtualMFADevices() && Objects.equals(this.virtualMFADevices(), other.virtualMFADevices()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListVirtualMfaDevicesResponse").add("VirtualMFADevices", this.hasVirtualMFADevices() ? this.virtualMFADevices() : null).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VirtualMFADevices": {
                return Optional.ofNullable(clazz.cast(this.virtualMFADevices()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVirtualMfaDevicesResponse, T> g) {
        return obj -> g.apply((ListVirtualMfaDevicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<VirtualMFADevice> virtualMFADevices = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualMfaDevicesResponse model) {
            super(model);
            this.virtualMFADevices(model.virtualMFADevices);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<VirtualMFADevice.Builder> getVirtualMFADevices() {
            if (this.virtualMFADevices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.virtualMFADevices != null ? (Collection)this.virtualMFADevices.stream().map(VirtualMFADevice::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder virtualMFADevices(Collection<VirtualMFADevice> virtualMFADevices) {
            this.virtualMFADevices = _virtualMFADeviceListTypeCopier.copy(virtualMFADevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualMFADevices(VirtualMFADevice ... virtualMFADevices) {
            this.virtualMFADevices(Arrays.asList(virtualMFADevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualMFADevices(Consumer<VirtualMFADevice.Builder> ... virtualMFADevices) {
            this.virtualMFADevices(Stream.of(virtualMFADevices).map(c -> (VirtualMFADevice)((VirtualMFADevice.Builder)VirtualMFADevice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVirtualMFADevices(Collection<VirtualMFADevice.BuilderImpl> virtualMFADevices) {
            this.virtualMFADevices = _virtualMFADeviceListTypeCopier.copyFromBuilder(virtualMFADevices);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListVirtualMfaDevicesResponse build() {
            return new ListVirtualMfaDevicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVirtualMfaDevicesResponse> {
        public Builder virtualMFADevices(Collection<VirtualMFADevice> var1);

        public Builder virtualMFADevices(VirtualMFADevice ... var1);

        public Builder virtualMFADevices(Consumer<VirtualMFADevice.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

