/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.ServiceSpecificCredentialMetadata;
import software.amazon.awssdk.services.iam.model.ServiceSpecificCredentialsListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceSpecificCredentialsResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListServiceSpecificCredentialsResponse> {
    private static final SdkField<List<ServiceSpecificCredentialMetadata>> SERVICE_SPECIFIC_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceSpecificCredentials").getter(ListServiceSpecificCredentialsResponse.getter(ListServiceSpecificCredentialsResponse::serviceSpecificCredentials)).setter(ListServiceSpecificCredentialsResponse.setter(Builder::serviceSpecificCredentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSpecificCredentials").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceSpecificCredentialMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_SPECIFIC_CREDENTIALS_FIELD));
    private final List<ServiceSpecificCredentialMetadata> serviceSpecificCredentials;

    private ListServiceSpecificCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.serviceSpecificCredentials = builder.serviceSpecificCredentials;
    }

    public boolean hasServiceSpecificCredentials() {
        return this.serviceSpecificCredentials != null && !(this.serviceSpecificCredentials instanceof SdkAutoConstructList);
    }

    public List<ServiceSpecificCredentialMetadata> serviceSpecificCredentials() {
        return this.serviceSpecificCredentials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceSpecificCredentials() ? this.serviceSpecificCredentials() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceSpecificCredentialsResponse)) {
            return false;
        }
        ListServiceSpecificCredentialsResponse other = (ListServiceSpecificCredentialsResponse)((Object)obj);
        return this.hasServiceSpecificCredentials() == other.hasServiceSpecificCredentials() && Objects.equals(this.serviceSpecificCredentials(), other.serviceSpecificCredentials());
    }

    public String toString() {
        return ToString.builder((String)"ListServiceSpecificCredentialsResponse").add("ServiceSpecificCredentials", this.hasServiceSpecificCredentials() ? this.serviceSpecificCredentials() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceSpecificCredentials": {
                return Optional.ofNullable(clazz.cast(this.serviceSpecificCredentials()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceSpecificCredentialsResponse, T> g) {
        return obj -> g.apply((ListServiceSpecificCredentialsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<ServiceSpecificCredentialMetadata> serviceSpecificCredentials = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceSpecificCredentialsResponse model) {
            super(model);
            this.serviceSpecificCredentials(model.serviceSpecificCredentials);
        }

        public final Collection<ServiceSpecificCredentialMetadata.Builder> getServiceSpecificCredentials() {
            if (this.serviceSpecificCredentials instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceSpecificCredentials != null ? (Collection)this.serviceSpecificCredentials.stream().map(ServiceSpecificCredentialMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceSpecificCredentials(Collection<ServiceSpecificCredentialMetadata> serviceSpecificCredentials) {
            this.serviceSpecificCredentials = ServiceSpecificCredentialsListTypeCopier.copy(serviceSpecificCredentials);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceSpecificCredentials(ServiceSpecificCredentialMetadata ... serviceSpecificCredentials) {
            this.serviceSpecificCredentials(Arrays.asList(serviceSpecificCredentials));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceSpecificCredentials(Consumer<ServiceSpecificCredentialMetadata.Builder> ... serviceSpecificCredentials) {
            this.serviceSpecificCredentials(Stream.of(serviceSpecificCredentials).map(c -> (ServiceSpecificCredentialMetadata)((ServiceSpecificCredentialMetadata.Builder)ServiceSpecificCredentialMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceSpecificCredentials(Collection<ServiceSpecificCredentialMetadata.BuilderImpl> serviceSpecificCredentials) {
            this.serviceSpecificCredentials = ServiceSpecificCredentialsListTypeCopier.copyFromBuilder(serviceSpecificCredentials);
        }

        @Override
        public ListServiceSpecificCredentialsResponse build() {
            return new ListServiceSpecificCredentialsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceSpecificCredentialsResponse> {
        public Builder serviceSpecificCredentials(Collection<ServiceSpecificCredentialMetadata> var1);

        public Builder serviceSpecificCredentials(ServiceSpecificCredentialMetadata ... var1);

        public Builder serviceSpecificCredentials(Consumer<ServiceSpecificCredentialMetadata.Builder> ... var1);
    }
}

