/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.services.iam.model._serviceNamespaceListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPoliciesGrantingServiceAccessRequest
extends IamRequest
implements ToCopyableBuilder<Builder, ListPoliciesGrantingServiceAccessRequest> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPoliciesGrantingServiceAccessRequest.getter(ListPoliciesGrantingServiceAccessRequest::marker)).setter(ListPoliciesGrantingServiceAccessRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPoliciesGrantingServiceAccessRequest.getter(ListPoliciesGrantingServiceAccessRequest::arn)).setter(ListPoliciesGrantingServiceAccessRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<List<String>> SERVICE_NAMESPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListPoliciesGrantingServiceAccessRequest.getter(ListPoliciesGrantingServiceAccessRequest::serviceNamespaces)).setter(ListPoliciesGrantingServiceAccessRequest.setter(Builder::serviceNamespaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, ARN_FIELD, SERVICE_NAMESPACES_FIELD));
    private final String marker;
    private final String arn;
    private final List<String> serviceNamespaces;

    private ListPoliciesGrantingServiceAccessRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.arn = builder.arn;
        this.serviceNamespaces = builder.serviceNamespaces;
    }

    public String marker() {
        return this.marker;
    }

    public String arn() {
        return this.arn;
    }

    public boolean hasServiceNamespaces() {
        return this.serviceNamespaces != null && !(this.serviceNamespaces instanceof SdkAutoConstructList);
    }

    public List<String> serviceNamespaces() {
        return this.serviceNamespaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNamespaces());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesGrantingServiceAccessRequest)) {
            return false;
        }
        ListPoliciesGrantingServiceAccessRequest other = (ListPoliciesGrantingServiceAccessRequest)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.serviceNamespaces(), other.serviceNamespaces());
    }

    public String toString() {
        return ToString.builder((String)"ListPoliciesGrantingServiceAccessRequest").add("Marker", (Object)this.marker()).add("Arn", (Object)this.arn()).add("ServiceNamespaces", this.serviceNamespaces()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ServiceNamespaces": {
                return Optional.ofNullable(clazz.cast(this.serviceNamespaces()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPoliciesGrantingServiceAccessRequest, T> g) {
        return obj -> g.apply((ListPoliciesGrantingServiceAccessRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String marker;
        private String arn;
        private List<String> serviceNamespaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesGrantingServiceAccessRequest model) {
            super(model);
            this.marker(model.marker);
            this.arn(model.arn);
            this.serviceNamespaces(model.serviceNamespaces);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<String> getServiceNamespaces() {
            return this.serviceNamespaces;
        }

        @Override
        public final Builder serviceNamespaces(Collection<String> serviceNamespaces) {
            this.serviceNamespaces = _serviceNamespaceListTypeCopier.copy(serviceNamespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceNamespaces(String ... serviceNamespaces) {
            this.serviceNamespaces(Arrays.asList(serviceNamespaces));
            return this;
        }

        public final void setServiceNamespaces(Collection<String> serviceNamespaces) {
            this.serviceNamespaces = _serviceNamespaceListTypeCopier.copy(serviceNamespaces);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPoliciesGrantingServiceAccessRequest build() {
            return new ListPoliciesGrantingServiceAccessRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPoliciesGrantingServiceAccessRequest> {
        public Builder marker(String var1);

        public Builder arn(String var1);

        public Builder serviceNamespaces(Collection<String> var1);

        public Builder serviceNamespaces(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

