/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.EncodingType;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSshPublicKeyRequest
extends IamRequest
implements ToCopyableBuilder<Builder, GetSshPublicKeyRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSshPublicKeyRequest.getter(GetSshPublicKeyRequest::userName)).setter(GetSshPublicKeyRequest.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> SSH_PUBLIC_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSshPublicKeyRequest.getter(GetSshPublicKeyRequest::sshPublicKeyId)).setter(GetSshPublicKeyRequest.setter(Builder::sshPublicKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSHPublicKeyId").build()}).build();
    private static final SdkField<String> ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSshPublicKeyRequest.getter(GetSshPublicKeyRequest::encodingAsString)).setter(GetSshPublicKeyRequest.setter(Builder::encoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encoding").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, SSH_PUBLIC_KEY_ID_FIELD, ENCODING_FIELD));
    private final String userName;
    private final String sshPublicKeyId;
    private final String encoding;

    private GetSshPublicKeyRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.sshPublicKeyId = builder.sshPublicKeyId;
        this.encoding = builder.encoding;
    }

    public String userName() {
        return this.userName;
    }

    public String sshPublicKeyId() {
        return this.sshPublicKeyId;
    }

    public EncodingType encoding() {
        return EncodingType.fromValue(this.encoding);
    }

    public String encodingAsString() {
        return this.encoding;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.encodingAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSshPublicKeyRequest)) {
            return false;
        }
        GetSshPublicKeyRequest other = (GetSshPublicKeyRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.sshPublicKeyId(), other.sshPublicKeyId()) && Objects.equals(this.encodingAsString(), other.encodingAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetSshPublicKeyRequest").add("UserName", (Object)this.userName()).add("SSHPublicKeyId", (Object)this.sshPublicKeyId()).add("Encoding", (Object)this.encodingAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "SSHPublicKeyId": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKeyId()));
            }
            case "Encoding": {
                return Optional.ofNullable(clazz.cast(this.encodingAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSshPublicKeyRequest, T> g) {
        return obj -> g.apply((GetSshPublicKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String userName;
        private String sshPublicKeyId;
        private String encoding;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSshPublicKeyRequest model) {
            super(model);
            this.userName(model.userName);
            this.sshPublicKeyId(model.sshPublicKeyId);
            this.encoding(model.encoding);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getSshPublicKeyId() {
            return this.sshPublicKeyId;
        }

        @Override
        public final Builder sshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
            return this;
        }

        public final void setSshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
        }

        public final String getEncoding() {
            return this.encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        @Override
        public final Builder encoding(EncodingType encoding) {
            this.encoding(encoding == null ? null : encoding.toString());
            return this;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSshPublicKeyRequest build() {
            return new GetSshPublicKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSshPublicKeyRequest> {
        public Builder userName(String var1);

        public Builder sshPublicKeyId(String var1);

        public Builder encoding(String var1);

        public Builder encoding(EncodingType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

