/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.AccessAdvisorUsageGranularityType;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateServiceLastAccessedDetailsRequest
extends IamRequest
implements ToCopyableBuilder<Builder, GenerateServiceLastAccessedDetailsRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GenerateServiceLastAccessedDetailsRequest.getter(GenerateServiceLastAccessedDetailsRequest::arn)).setter(GenerateServiceLastAccessedDetailsRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GenerateServiceLastAccessedDetailsRequest.getter(GenerateServiceLastAccessedDetailsRequest::granularityAsString)).setter(GenerateServiceLastAccessedDetailsRequest.setter(Builder::granularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, GRANULARITY_FIELD));
    private final String arn;
    private final String granularity;

    private GenerateServiceLastAccessedDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.granularity = builder.granularity;
    }

    public String arn() {
        return this.arn;
    }

    public AccessAdvisorUsageGranularityType granularity() {
        return AccessAdvisorUsageGranularityType.fromValue(this.granularity);
    }

    public String granularityAsString() {
        return this.granularity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.granularityAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateServiceLastAccessedDetailsRequest)) {
            return false;
        }
        GenerateServiceLastAccessedDetailsRequest other = (GenerateServiceLastAccessedDetailsRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.granularityAsString(), other.granularityAsString());
    }

    public String toString() {
        return ToString.builder((String)"GenerateServiceLastAccessedDetailsRequest").add("Arn", (Object)this.arn()).add("Granularity", (Object)this.granularityAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Granularity": {
                return Optional.ofNullable(clazz.cast(this.granularityAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerateServiceLastAccessedDetailsRequest, T> g) {
        return obj -> g.apply((GenerateServiceLastAccessedDetailsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String arn;
        private String granularity;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateServiceLastAccessedDetailsRequest model) {
            super(model);
            this.arn(model.arn);
            this.granularity(model.granularity);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getGranularity() {
            return this.granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(AccessAdvisorUsageGranularityType granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateServiceLastAccessedDetailsRequest build() {
            return new GenerateServiceLastAccessedDetailsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateServiceLastAccessedDetailsRequest> {
        public Builder arn(String var1);

        public Builder granularity(String var1);

        public Builder granularity(AccessAdvisorUsageGranularityType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

