/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateOrganizationsAccessReportRequest
extends IamRequest
implements ToCopyableBuilder<Builder, GenerateOrganizationsAccessReportRequest> {
    private static final SdkField<String> ENTITY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GenerateOrganizationsAccessReportRequest.getter(GenerateOrganizationsAccessReportRequest::entityPath)).setter(GenerateOrganizationsAccessReportRequest.setter(Builder::entityPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityPath").build()}).build();
    private static final SdkField<String> ORGANIZATIONS_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GenerateOrganizationsAccessReportRequest.getter(GenerateOrganizationsAccessReportRequest::organizationsPolicyId)).setter(GenerateOrganizationsAccessReportRequest.setter(Builder::organizationsPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationsPolicyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_PATH_FIELD, ORGANIZATIONS_POLICY_ID_FIELD));
    private final String entityPath;
    private final String organizationsPolicyId;

    private GenerateOrganizationsAccessReportRequest(BuilderImpl builder) {
        super(builder);
        this.entityPath = builder.entityPath;
        this.organizationsPolicyId = builder.organizationsPolicyId;
    }

    public String entityPath() {
        return this.entityPath;
    }

    public String organizationsPolicyId() {
        return this.organizationsPolicyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.entityPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationsPolicyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateOrganizationsAccessReportRequest)) {
            return false;
        }
        GenerateOrganizationsAccessReportRequest other = (GenerateOrganizationsAccessReportRequest)((Object)obj);
        return Objects.equals(this.entityPath(), other.entityPath()) && Objects.equals(this.organizationsPolicyId(), other.organizationsPolicyId());
    }

    public String toString() {
        return ToString.builder((String)"GenerateOrganizationsAccessReportRequest").add("EntityPath", (Object)this.entityPath()).add("OrganizationsPolicyId", (Object)this.organizationsPolicyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityPath": {
                return Optional.ofNullable(clazz.cast(this.entityPath()));
            }
            case "OrganizationsPolicyId": {
                return Optional.ofNullable(clazz.cast(this.organizationsPolicyId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerateOrganizationsAccessReportRequest, T> g) {
        return obj -> g.apply((GenerateOrganizationsAccessReportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String entityPath;
        private String organizationsPolicyId;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateOrganizationsAccessReportRequest model) {
            super(model);
            this.entityPath(model.entityPath);
            this.organizationsPolicyId(model.organizationsPolicyId);
        }

        public final String getEntityPath() {
            return this.entityPath;
        }

        @Override
        public final Builder entityPath(String entityPath) {
            this.entityPath = entityPath;
            return this;
        }

        public final void setEntityPath(String entityPath) {
            this.entityPath = entityPath;
        }

        public final String getOrganizationsPolicyId() {
            return this.organizationsPolicyId;
        }

        @Override
        public final Builder organizationsPolicyId(String organizationsPolicyId) {
            this.organizationsPolicyId = organizationsPolicyId;
            return this;
        }

        public final void setOrganizationsPolicyId(String organizationsPolicyId) {
            this.organizationsPolicyId = organizationsPolicyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateOrganizationsAccessReportRequest build() {
            return new GenerateOrganizationsAccessReportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateOrganizationsAccessReportRequest> {
        public Builder entityPath(String var1);

        public Builder organizationsPolicyId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

