/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.ActionNameListTypeCopier;
import software.amazon.awssdk.services.iam.model.ContextEntry;
import software.amazon.awssdk.services.iam.model.ContextEntryListTypeCopier;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.services.iam.model.ResourceNameListTypeCopier;
import software.amazon.awssdk.services.iam.model.SimulationPolicyListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SimulatePrincipalPolicyRequest
extends IamRequest
implements ToCopyableBuilder<Builder, SimulatePrincipalPolicyRequest> {
    private static final SdkField<String> POLICY_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimulatePrincipalPolicyRequest.getter(SimulatePrincipalPolicyRequest::policySourceArn)).setter(SimulatePrincipalPolicyRequest.setter(Builder::policySourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicySourceArn").build()}).build();
    private static final SdkField<List<String>> POLICY_INPUT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SimulatePrincipalPolicyRequest.getter(SimulatePrincipalPolicyRequest::policyInputList)).setter(SimulatePrincipalPolicyRequest.setter(Builder::policyInputList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyInputList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACTION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SimulatePrincipalPolicyRequest.getter(SimulatePrincipalPolicyRequest::actionNames)).setter(SimulatePrincipalPolicyRequest.setter(Builder::actionNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SimulatePrincipalPolicyRequest.getter(SimulatePrincipalPolicyRequest::resourceArns)).setter(SimulatePrincipalPolicyRequest.setter(Builder::resourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimulatePrincipalPolicyRequest.getter(SimulatePrincipalPolicyRequest::resourcePolicy)).setter(SimulatePrincipalPolicyRequest.setter(Builder::resourcePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePolicy").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimulatePrincipalPolicyRequest.getter(SimulatePrincipalPolicyRequest::resourceOwner)).setter(SimulatePrincipalPolicyRequest.setter(Builder::resourceOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwner").build()}).build();
    private static final SdkField<String> CALLER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimulatePrincipalPolicyRequest.getter(SimulatePrincipalPolicyRequest::callerArn)).setter(SimulatePrincipalPolicyRequest.setter(Builder::callerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerArn").build()}).build();
    private static final SdkField<List<ContextEntry>> CONTEXT_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SimulatePrincipalPolicyRequest.getter(SimulatePrincipalPolicyRequest::contextEntries)).setter(SimulatePrincipalPolicyRequest.setter(Builder::contextEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContextEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_HANDLING_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimulatePrincipalPolicyRequest.getter(SimulatePrincipalPolicyRequest::resourceHandlingOption)).setter(SimulatePrincipalPolicyRequest.setter(Builder::resourceHandlingOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceHandlingOption").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SimulatePrincipalPolicyRequest.getter(SimulatePrincipalPolicyRequest::maxItems)).setter(SimulatePrincipalPolicyRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimulatePrincipalPolicyRequest.getter(SimulatePrincipalPolicyRequest::marker)).setter(SimulatePrincipalPolicyRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_SOURCE_ARN_FIELD, POLICY_INPUT_LIST_FIELD, ACTION_NAMES_FIELD, RESOURCE_ARNS_FIELD, RESOURCE_POLICY_FIELD, RESOURCE_OWNER_FIELD, CALLER_ARN_FIELD, CONTEXT_ENTRIES_FIELD, RESOURCE_HANDLING_OPTION_FIELD, MAX_ITEMS_FIELD, MARKER_FIELD));
    private final String policySourceArn;
    private final List<String> policyInputList;
    private final List<String> actionNames;
    private final List<String> resourceArns;
    private final String resourcePolicy;
    private final String resourceOwner;
    private final String callerArn;
    private final List<ContextEntry> contextEntries;
    private final String resourceHandlingOption;
    private final Integer maxItems;
    private final String marker;

    private SimulatePrincipalPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policySourceArn = builder.policySourceArn;
        this.policyInputList = builder.policyInputList;
        this.actionNames = builder.actionNames;
        this.resourceArns = builder.resourceArns;
        this.resourcePolicy = builder.resourcePolicy;
        this.resourceOwner = builder.resourceOwner;
        this.callerArn = builder.callerArn;
        this.contextEntries = builder.contextEntries;
        this.resourceHandlingOption = builder.resourceHandlingOption;
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
    }

    public String policySourceArn() {
        return this.policySourceArn;
    }

    public boolean hasPolicyInputList() {
        return this.policyInputList != null && !(this.policyInputList instanceof SdkAutoConstructList);
    }

    public List<String> policyInputList() {
        return this.policyInputList;
    }

    public boolean hasActionNames() {
        return this.actionNames != null && !(this.actionNames instanceof SdkAutoConstructList);
    }

    public List<String> actionNames() {
        return this.actionNames;
    }

    public boolean hasResourceArns() {
        return this.resourceArns != null && !(this.resourceArns instanceof SdkAutoConstructList);
    }

    public List<String> resourceArns() {
        return this.resourceArns;
    }

    public String resourcePolicy() {
        return this.resourcePolicy;
    }

    public String resourceOwner() {
        return this.resourceOwner;
    }

    public String callerArn() {
        return this.callerArn;
    }

    public boolean hasContextEntries() {
        return this.contextEntries != null && !(this.contextEntries instanceof SdkAutoConstructList);
    }

    public List<ContextEntry> contextEntries() {
        return this.contextEntries;
    }

    public String resourceHandlingOption() {
        return this.resourceHandlingOption;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policySourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyInputList());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.callerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextEntries());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceHandlingOption());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulatePrincipalPolicyRequest)) {
            return false;
        }
        SimulatePrincipalPolicyRequest other = (SimulatePrincipalPolicyRequest)((Object)obj);
        return Objects.equals(this.policySourceArn(), other.policySourceArn()) && Objects.equals(this.policyInputList(), other.policyInputList()) && Objects.equals(this.actionNames(), other.actionNames()) && Objects.equals(this.resourceArns(), other.resourceArns()) && Objects.equals(this.resourcePolicy(), other.resourcePolicy()) && Objects.equals(this.resourceOwner(), other.resourceOwner()) && Objects.equals(this.callerArn(), other.callerArn()) && Objects.equals(this.contextEntries(), other.contextEntries()) && Objects.equals(this.resourceHandlingOption(), other.resourceHandlingOption()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"SimulatePrincipalPolicyRequest").add("PolicySourceArn", (Object)this.policySourceArn()).add("PolicyInputList", this.policyInputList()).add("ActionNames", this.actionNames()).add("ResourceArns", this.resourceArns()).add("ResourcePolicy", (Object)this.resourcePolicy()).add("ResourceOwner", (Object)this.resourceOwner()).add("CallerArn", (Object)this.callerArn()).add("ContextEntries", this.contextEntries()).add("ResourceHandlingOption", (Object)this.resourceHandlingOption()).add("MaxItems", (Object)this.maxItems()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicySourceArn": {
                return Optional.ofNullable(clazz.cast(this.policySourceArn()));
            }
            case "PolicyInputList": {
                return Optional.ofNullable(clazz.cast(this.policyInputList()));
            }
            case "ActionNames": {
                return Optional.ofNullable(clazz.cast(this.actionNames()));
            }
            case "ResourceArns": {
                return Optional.ofNullable(clazz.cast(this.resourceArns()));
            }
            case "ResourcePolicy": {
                return Optional.ofNullable(clazz.cast(this.resourcePolicy()));
            }
            case "ResourceOwner": {
                return Optional.ofNullable(clazz.cast(this.resourceOwner()));
            }
            case "CallerArn": {
                return Optional.ofNullable(clazz.cast(this.callerArn()));
            }
            case "ContextEntries": {
                return Optional.ofNullable(clazz.cast(this.contextEntries()));
            }
            case "ResourceHandlingOption": {
                return Optional.ofNullable(clazz.cast(this.resourceHandlingOption()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimulatePrincipalPolicyRequest, T> g) {
        return obj -> g.apply((SimulatePrincipalPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String policySourceArn;
        private List<String> policyInputList = DefaultSdkAutoConstructList.getInstance();
        private List<String> actionNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();
        private String resourcePolicy;
        private String resourceOwner;
        private String callerArn;
        private List<ContextEntry> contextEntries = DefaultSdkAutoConstructList.getInstance();
        private String resourceHandlingOption;
        private Integer maxItems;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(SimulatePrincipalPolicyRequest model) {
            super(model);
            this.policySourceArn(model.policySourceArn);
            this.policyInputList(model.policyInputList);
            this.actionNames(model.actionNames);
            this.resourceArns(model.resourceArns);
            this.resourcePolicy(model.resourcePolicy);
            this.resourceOwner(model.resourceOwner);
            this.callerArn(model.callerArn);
            this.contextEntries(model.contextEntries);
            this.resourceHandlingOption(model.resourceHandlingOption);
            this.maxItems(model.maxItems);
            this.marker(model.marker);
        }

        public final String getPolicySourceArn() {
            return this.policySourceArn;
        }

        @Override
        public final Builder policySourceArn(String policySourceArn) {
            this.policySourceArn = policySourceArn;
            return this;
        }

        public final void setPolicySourceArn(String policySourceArn) {
            this.policySourceArn = policySourceArn;
        }

        public final Collection<String> getPolicyInputList() {
            return this.policyInputList;
        }

        @Override
        public final Builder policyInputList(Collection<String> policyInputList) {
            this.policyInputList = SimulationPolicyListTypeCopier.copy(policyInputList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyInputList(String ... policyInputList) {
            this.policyInputList(Arrays.asList(policyInputList));
            return this;
        }

        public final void setPolicyInputList(Collection<String> policyInputList) {
            this.policyInputList = SimulationPolicyListTypeCopier.copy(policyInputList);
        }

        public final Collection<String> getActionNames() {
            return this.actionNames;
        }

        @Override
        public final Builder actionNames(Collection<String> actionNames) {
            this.actionNames = ActionNameListTypeCopier.copy(actionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionNames(String ... actionNames) {
            this.actionNames(Arrays.asList(actionNames));
            return this;
        }

        public final void setActionNames(Collection<String> actionNames) {
            this.actionNames = ActionNameListTypeCopier.copy(actionNames);
        }

        public final Collection<String> getResourceArns() {
            return this.resourceArns;
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceNameListTypeCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceNameListTypeCopier.copy(resourceArns);
        }

        public final String getResourcePolicy() {
            return this.resourcePolicy;
        }

        @Override
        public final Builder resourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        public final void setResourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
        }

        public final String getResourceOwner() {
            return this.resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        public final String getCallerArn() {
            return this.callerArn;
        }

        @Override
        public final Builder callerArn(String callerArn) {
            this.callerArn = callerArn;
            return this;
        }

        public final void setCallerArn(String callerArn) {
            this.callerArn = callerArn;
        }

        public final Collection<ContextEntry.Builder> getContextEntries() {
            return this.contextEntries != null ? (Collection)this.contextEntries.stream().map(ContextEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder contextEntries(Collection<ContextEntry> contextEntries) {
            this.contextEntries = ContextEntryListTypeCopier.copy(contextEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextEntries(ContextEntry ... contextEntries) {
            this.contextEntries(Arrays.asList(contextEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextEntries(Consumer<ContextEntry.Builder> ... contextEntries) {
            this.contextEntries(Stream.of(contextEntries).map(c -> (ContextEntry)((ContextEntry.Builder)ContextEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContextEntries(Collection<ContextEntry.BuilderImpl> contextEntries) {
            this.contextEntries = ContextEntryListTypeCopier.copyFromBuilder(contextEntries);
        }

        public final String getResourceHandlingOption() {
            return this.resourceHandlingOption;
        }

        @Override
        public final Builder resourceHandlingOption(String resourceHandlingOption) {
            this.resourceHandlingOption = resourceHandlingOption;
            return this;
        }

        public final void setResourceHandlingOption(String resourceHandlingOption) {
            this.resourceHandlingOption = resourceHandlingOption;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SimulatePrincipalPolicyRequest build() {
            return new SimulatePrincipalPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SimulatePrincipalPolicyRequest> {
        public Builder policySourceArn(String var1);

        public Builder policyInputList(Collection<String> var1);

        public Builder policyInputList(String ... var1);

        public Builder actionNames(Collection<String> var1);

        public Builder actionNames(String ... var1);

        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);

        public Builder resourcePolicy(String var1);

        public Builder resourceOwner(String var1);

        public Builder callerArn(String var1);

        public Builder contextEntries(Collection<ContextEntry> var1);

        public Builder contextEntries(ContextEntry ... var1);

        public Builder contextEntries(Consumer<ContextEntry.Builder> ... var1);

        public Builder resourceHandlingOption(String var1);

        public Builder maxItems(Integer var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

