/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.model.Group;
import software.amazon.awssdk.services.iam.model.ListGroupsRequest;
import software.amazon.awssdk.services.iam.model.ListGroupsResponse;

public class ListGroupsIterable
implements SdkIterable<ListGroupsResponse> {
    private final IamClient client;
    private final ListGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGroupsIterable(IamClient client, ListGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGroupsResponseFetcher();
    }

    public Iterator<ListGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Group> groups() {
        Function<ListGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groups() != null) {
                return response.groups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListGroupsIterable resume(ListGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListGroupsIterable(this.client, (ListGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListGroupsResponseFetcher
    implements SyncPageFetcher<ListGroupsResponse> {
        private ListGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListGroupsResponse nextPage(ListGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListGroupsIterable.this.client.listGroups(ListGroupsIterable.this.firstRequest);
            }
            return ListGroupsIterable.this.client.listGroups((ListGroupsRequest)((Object)ListGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

