/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iam.model.SigningCertificate;

public class SigningCertificateUnmarshaller
implements Unmarshaller<SigningCertificate, StaxUnmarshallerContext> {
    private static final SigningCertificateUnmarshaller INSTANCE = new SigningCertificateUnmarshaller();

    public SigningCertificate unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        SigningCertificate.Builder signingCertificate = SigningCertificate.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("UserName", targetDepth)) {
                    signingCertificate.userName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CertificateId", targetDepth)) {
                    signingCertificate.certificateId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CertificateBody", targetDepth)) {
                    signingCertificate.certificateBody(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    signingCertificate.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("UploadDate", targetDepth)) continue;
                signingCertificate.uploadDate(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (SigningCertificate)signingCertificate.build();
    }

    public static SigningCertificateUnmarshaller getInstance() {
        return INSTANCE;
    }
}

