/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest;

public class ListPolicyVersionsRequestMarshaller
implements Marshaller<Request<ListPolicyVersionsRequest>, ListPolicyVersionsRequest> {
    public Request<ListPolicyVersionsRequest> marshall(ListPolicyVersionsRequest listPolicyVersionsRequest) {
        if (listPolicyVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)listPolicyVersionsRequest, "IAMClient");
        request.addParameter("Action", "ListPolicyVersions");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listPolicyVersionsRequest.policyArn() != null) {
            request.addParameter("PolicyArn", StringUtils.fromString((String)listPolicyVersionsRequest.policyArn()));
        }
        if (listPolicyVersionsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listPolicyVersionsRequest.marker()));
        }
        if (listPolicyVersionsRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)listPolicyVersionsRequest.maxItems()));
        }
        return request;
    }
}

