/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.GetSSHPublicKeyRequest;

public class GetSSHPublicKeyRequestMarshaller
implements Marshaller<Request<GetSSHPublicKeyRequest>, GetSSHPublicKeyRequest> {
    public Request<GetSSHPublicKeyRequest> marshall(GetSSHPublicKeyRequest getSSHPublicKeyRequest) {
        if (getSSHPublicKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)getSSHPublicKeyRequest, "IAMClient");
        request.addParameter("Action", "GetSSHPublicKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getSSHPublicKeyRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)getSSHPublicKeyRequest.userName()));
        }
        if (getSSHPublicKeyRequest.sshPublicKeyId() != null) {
            request.addParameter("SSHPublicKeyId", StringUtils.fromString((String)getSSHPublicKeyRequest.sshPublicKeyId()));
        }
        if (getSSHPublicKeyRequest.encodingString() != null) {
            request.addParameter("Encoding", StringUtils.fromString((String)getSSHPublicKeyRequest.encodingString()));
        }
        return request;
    }
}

