/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.GetRoleRequest;

public class GetRoleRequestMarshaller
implements Marshaller<Request<GetRoleRequest>, GetRoleRequest> {
    public Request<GetRoleRequest> marshall(GetRoleRequest getRoleRequest) {
        if (getRoleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)getRoleRequest, "IAMClient");
        request.addParameter("Action", "GetRole");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getRoleRequest.roleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)getRoleRequest.roleName()));
        }
        return request;
    }
}

