/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.GetGroupRequest;

public class GetGroupRequestMarshaller
implements Marshaller<Request<GetGroupRequest>, GetGroupRequest> {
    public Request<GetGroupRequest> marshall(GetGroupRequest getGroupRequest) {
        if (getGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)getGroupRequest, "IAMClient");
        request.addParameter("Action", "GetGroup");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getGroupRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString((String)getGroupRequest.groupName()));
        }
        if (getGroupRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)getGroupRequest.marker()));
        }
        if (getGroupRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)getGroupRequest.maxItems()));
        }
        return request;
    }
}

