/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.EvaluationResult;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyRequest;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyResponse;

public final class SimulatePrincipalPolicyPaginator
implements SdkIterable<SimulatePrincipalPolicyResponse> {
    private final IAMClient client;
    private final SimulatePrincipalPolicyRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public SimulatePrincipalPolicyPaginator(IAMClient client, SimulatePrincipalPolicyRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SimulatePrincipalPolicyResponseFetcher();
    }

    public Iterator<SimulatePrincipalPolicyResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<EvaluationResult> evaluationResults() {
        Function<SimulatePrincipalPolicyResponse, Iterator> getIterator = response -> response != null ? response.evaluationResults().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class SimulatePrincipalPolicyResponseFetcher
    implements NextPageFetcher<SimulatePrincipalPolicyResponse> {
        private SimulatePrincipalPolicyResponseFetcher() {
        }

        public boolean hasNextPage(SimulatePrincipalPolicyResponse previousPage) {
            return previousPage.isTruncated();
        }

        public SimulatePrincipalPolicyResponse nextPage(SimulatePrincipalPolicyResponse previousPage) {
            if (previousPage == null) {
                return SimulatePrincipalPolicyPaginator.this.client.simulatePrincipalPolicy(SimulatePrincipalPolicyPaginator.this.firstRequest);
            }
            return SimulatePrincipalPolicyPaginator.this.client.simulatePrincipalPolicy((SimulatePrincipalPolicyRequest)((Object)SimulatePrincipalPolicyPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

