/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UploadSigningCertificateRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, UploadSigningCertificateRequest> {
    private final String userName;
    private final String certificateBody;

    private UploadSigningCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.certificateBody = builder.certificateBody;
    }

    public String userName() {
        return this.userName;
    }

    public String certificateBody() {
        return this.certificateBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateBody());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadSigningCertificateRequest)) {
            return false;
        }
        UploadSigningCertificateRequest other = (UploadSigningCertificateRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.certificateBody(), other.certificateBody());
    }

    public String toString() {
        return ToString.builder((String)"UploadSigningCertificateRequest").add("UserName", (Object)this.userName()).add("CertificateBody", (Object)this.certificateBody()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "CertificateBody": {
                return Optional.of(clazz.cast(this.certificateBody()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String userName;
        private String certificateBody;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadSigningCertificateRequest model) {
            this.userName(model.userName);
            this.certificateBody(model.certificateBody);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getCertificateBody() {
            return this.certificateBody;
        }

        @Override
        public final Builder certificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
            return this;
        }

        public final void setCertificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UploadSigningCertificateRequest build() {
            return new UploadSigningCertificateRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, UploadSigningCertificateRequest> {
        public Builder userName(String var1);

        public Builder certificateBody(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

