/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.iam.model.StatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SSHPublicKey
implements ToCopyableBuilder<Builder, SSHPublicKey> {
    private final String userName;
    private final String sshPublicKeyId;
    private final String fingerprint;
    private final String sshPublicKeyBody;
    private final String status;
    private final Instant uploadDate;

    private SSHPublicKey(BuilderImpl builder) {
        this.userName = builder.userName;
        this.sshPublicKeyId = builder.sshPublicKeyId;
        this.fingerprint = builder.fingerprint;
        this.sshPublicKeyBody = builder.sshPublicKeyBody;
        this.status = builder.status;
        this.uploadDate = builder.uploadDate;
    }

    public String userName() {
        return this.userName;
    }

    public String sshPublicKeyId() {
        return this.sshPublicKeyId;
    }

    public String fingerprint() {
        return this.fingerprint;
    }

    public String sshPublicKeyBody() {
        return this.sshPublicKeyBody;
    }

    public StatusType status() {
        return StatusType.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Instant uploadDate() {
        return this.uploadDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKeyBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SSHPublicKey)) {
            return false;
        }
        SSHPublicKey other = (SSHPublicKey)obj;
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.sshPublicKeyId(), other.sshPublicKeyId()) && Objects.equals(this.fingerprint(), other.fingerprint()) && Objects.equals(this.sshPublicKeyBody(), other.sshPublicKeyBody()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.uploadDate(), other.uploadDate());
    }

    public String toString() {
        return ToString.builder((String)"SSHPublicKey").add("UserName", (Object)this.userName()).add("SSHPublicKeyId", (Object)this.sshPublicKeyId()).add("Fingerprint", (Object)this.fingerprint()).add("SSHPublicKeyBody", (Object)this.sshPublicKeyBody()).add("Status", (Object)this.statusString()).add("UploadDate", (Object)this.uploadDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "SSHPublicKeyId": {
                return Optional.of(clazz.cast(this.sshPublicKeyId()));
            }
            case "Fingerprint": {
                return Optional.of(clazz.cast(this.fingerprint()));
            }
            case "SSHPublicKeyBody": {
                return Optional.of(clazz.cast(this.sshPublicKeyBody()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "UploadDate": {
                return Optional.of(clazz.cast(this.uploadDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String sshPublicKeyId;
        private String fingerprint;
        private String sshPublicKeyBody;
        private String status;
        private Instant uploadDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SSHPublicKey model) {
            this.userName(model.userName);
            this.sshPublicKeyId(model.sshPublicKeyId);
            this.fingerprint(model.fingerprint);
            this.sshPublicKeyBody(model.sshPublicKeyBody);
            this.status(model.status);
            this.uploadDate(model.uploadDate);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getSSHPublicKeyId() {
            return this.sshPublicKeyId;
        }

        @Override
        public final Builder sshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
            return this;
        }

        public final void setSSHPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
        }

        public final String getFingerprint() {
            return this.fingerprint;
        }

        @Override
        public final Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public final void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        public final String getSSHPublicKeyBody() {
            return this.sshPublicKeyBody;
        }

        @Override
        public final Builder sshPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
            return this;
        }

        public final void setSSHPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getUploadDate() {
            return this.uploadDate;
        }

        @Override
        public final Builder uploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
            return this;
        }

        public final void setUploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
        }

        public SSHPublicKey build() {
            return new SSHPublicKey(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SSHPublicKey> {
        public Builder userName(String var1);

        public Builder sshPublicKeyId(String var1);

        public Builder fingerprint(String var1);

        public Builder sshPublicKeyBody(String var1);

        public Builder status(String var1);

        public Builder status(StatusType var1);

        public Builder uploadDate(Instant var1);
    }
}

