/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetPolicyVersionRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, GetPolicyVersionRequest> {
    private final String policyArn;
    private final String versionId;

    private GetPolicyVersionRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.versionId = builder.versionId;
    }

    public String policyArn() {
        return this.policyArn;
    }

    public String versionId() {
        return this.versionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyVersionRequest)) {
            return false;
        }
        GetPolicyVersionRequest other = (GetPolicyVersionRequest)((Object)obj);
        return Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.versionId(), other.versionId());
    }

    public String toString() {
        return ToString.builder((String)"GetPolicyVersionRequest").add("PolicyArn", (Object)this.policyArn()).add("VersionId", (Object)this.versionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyArn": {
                return Optional.of(clazz.cast(this.policyArn()));
            }
            case "VersionId": {
                return Optional.of(clazz.cast(this.versionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String policyArn;
        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyVersionRequest model) {
            this.policyArn(model.policyArn);
            this.versionId(model.versionId);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetPolicyVersionRequest build() {
            return new GetPolicyVersionRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, GetPolicyVersionRequest> {
        public Builder policyArn(String var1);

        public Builder versionId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

