/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteUserPolicyRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, DeleteUserPolicyRequest> {
    private final String userName;
    private final String policyName;

    private DeleteUserPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.policyName = builder.policyName;
    }

    public String userName() {
        return this.userName;
    }

    public String policyName() {
        return this.policyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteUserPolicyRequest)) {
            return false;
        }
        DeleteUserPolicyRequest other = (DeleteUserPolicyRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.policyName(), other.policyName());
    }

    public String toString() {
        return ToString.builder((String)"DeleteUserPolicyRequest").add("UserName", (Object)this.userName()).add("PolicyName", (Object)this.policyName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "PolicyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String userName;
        private String policyName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteUserPolicyRequest model) {
            this.userName(model.userName);
            this.policyName(model.policyName);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteUserPolicyRequest build() {
            return new DeleteUserPolicyRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, DeleteUserPolicyRequest> {
        public Builder userName(String var1);

        public Builder policyName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

