/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListUsersRequest;
import software.amazon.awssdk.services.iam.model.ListUsersResponse;
import software.amazon.awssdk.services.iam.model.User;

public final class ListUsersPaginator
implements SdkIterable<ListUsersResponse> {
    private final IAMClient client;
    private final ListUsersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListUsersPaginator(IAMClient client, ListUsersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListUsersResponseFetcher();
    }

    public Iterator<ListUsersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<User> users() {
        Function<ListUsersResponse, Iterator> getIterator = response -> response != null ? response.users().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListUsersResponseFetcher
    implements NextPageFetcher<ListUsersResponse> {
        private ListUsersResponseFetcher() {
        }

        public boolean hasNextPage(ListUsersResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListUsersResponse nextPage(ListUsersResponse previousPage) {
            if (previousPage == null) {
                return ListUsersPaginator.this.client.listUsers(ListUsersPaginator.this.firstRequest);
            }
            return ListUsersPaginator.this.client.listUsers((ListUsersRequest)((Object)ListUsersPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

